/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.PortableGridData;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.energy.EnergyContainerMenu;
import com.refinedmods.refinedstorage.common.support.energy.EnergyInfo;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public abstract class AbstractPortableGridContainerMenu
extends AbstractGridContainerMenu
implements EnergyContainerMenu {
    private final FilteredContainer diskInventory;
    private final EnergyInfo energyInfo;
    @Nullable
    private Slot diskSlot;

    AbstractPortableGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, PortableGridData portableGridData) {
        super(menuType, syncId, playerInventory, portableGridData.gridData());
        this.diskInventory = new FilteredContainer(1, StorageContainerItem.stackValidator());
        this.energyInfo = EnergyInfo.forClient(playerInventory.player, portableGridData.stored(), portableGridData.capacity());
    }

    AbstractPortableGridContainerMenu(MenuType<? extends AbstractGridContainerMenu> menuType, int syncId, Inventory playerInventory, DiskInventory diskInventory, Grid grid, EnergyStorage energyStorage) {
        super(menuType, syncId, playerInventory, grid);
        this.diskInventory = diskInventory;
        this.energyInfo = EnergyInfo.forServer(playerInventory.player, energyStorage::getStored, energyStorage::getCapacity);
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        this.energyInfo.detectChanges();
    }

    @Override
    protected boolean canTransferSlot(Slot slot) {
        return slot != this.diskSlot;
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        super.resized(playerInventoryY, topYStart, topYEnd);
        this.diskSlot = ValidatedSlot.forStorageContainer((Container)this.diskInventory, 0, -19, 8);
        this.addSlot(this.diskSlot);
        this.transferManager.addBiTransfer((Container)this.playerInventory, (Container)this.diskInventory);
    }

    @Override
    public EnergyInfo getEnergyInfo() {
        return this.energyInfo;
    }
}

