/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.refinedmods.refinedstorage.api.network.impl.node.externalstorage.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.iface.InterfaceBlock;
import com.refinedmods.refinedstorage.common.iface.InterfaceProxyExternalStorageProvider;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainerImpl;
import com.refinedmods.refinedstorage.common.storage.externalstorage.CompositeExternalStorageProvider;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageTrackedStorageRepository;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageWorkRate;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExternalStorageBlockEntity
extends AbstractCableLikeBlockEntity<ExternalStorageNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExternalStorageBlockEntity.class);
    private static final String TAG_TRACKED_RESOURCES = "tr";
    private final FilterWithFuzzyMode filter;
    private final StorageConfigurationContainerImpl configContainer;
    private final ExternalStorageTrackedStorageRepository trackedStorageRepository = new ExternalStorageTrackedStorageRepository(() -> ((AbstractExternalStorageBlockEntity)this).setChanged());
    private final ExternalStorageWorkRate workRate = new ExternalStorageWorkRate();
    private boolean initialized;

    protected AbstractExternalStorageBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getExternalStorage(), pos, state, new ExternalStorageNetworkNode(Platform.INSTANCE.getConfig().getExternalStorage().getEnergyUsage(), System::currentTimeMillis));
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractExternalStorageBlockEntity)this).setChanged(), ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration()::setFilters);
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setNormalizer(this.filter.createNormalizer());
        ((ExternalStorageNetworkNode)this.mainNetworkNode).setTrackingRepository(this.trackedStorageRepository);
        this.configContainer = new StorageConfigurationContainerImpl(((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration(), this.filter, () -> ((AbstractExternalStorageBlockEntity)this).setChanged(), this::getRedstoneMode, this::setRedstoneMode);
    }

    @Override
    public void setBlockState(BlockState newBlockState) {
        super.setBlockState(newBlockState);
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LOGGER.debug("Reloading external storage @ {} as block state has changed", (Object)this.worldPosition);
            this.loadStorage(serverLevel);
        }
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        Level level;
        super.activenessChanged(newActive);
        if (!this.initialized && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LOGGER.debug("Triggering initial load of external storage {}", (Object)this.worldPosition);
            this.loadStorage(serverLevel);
            this.initialized = true;
        }
    }

    void loadStorage(ServerLevel serverLevel) {
        Direction direction = AbstractDirectionalBlock.tryExtractDirection(this.getBlockState());
        LOGGER.debug("Loading storage for external storage with direction {} @ {}", (Object)direction, (Object)this.worldPosition);
        if (direction == null) {
            return;
        }
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = this.worldPosition.relative(direction);
        if (serverLevel.getBlockState(sourcePosition).getBlock() instanceof InterfaceBlock) {
            ((ExternalStorageNetworkNode)this.mainNetworkNode).initialize(new InterfaceProxyExternalStorageProvider((Level)serverLevel, sourcePosition));
        } else {
            ((ExternalStorageNetworkNode)this.mainNetworkNode).initialize(new CompositeExternalStorageProvider(RefinedStorageApi.INSTANCE.getExternalStorageProviderFactories().stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection)).toList()));
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.workRate.canDoWork()) {
            boolean hasChanges = ((ExternalStorageNetworkNode)this.mainNetworkNode).detectChanges();
            if (hasChanges) {
                LOGGER.debug("External storage @ {} has changed!", (Object)this.worldPosition);
                this.workRate.faster();
            } else {
                this.workRate.slower();
            }
        }
    }

    public void neighborChanged() {
        this.workRate.faster();
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_TRACKED_RESOURCES, this.trackedStorageRepository.toTag(provider));
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
        this.configContainer.save(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_TRACKED_RESOURCES)) {
            this.trackedStorageRepository.fromTag(Objects.requireNonNull(tag.get(TAG_TRACKED_RESOURCES)), provider);
        }
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
        this.configContainer.load(tag);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilters(filters);
    }

    void setFilterMode(FilterMode mode) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilterMode(mode);
        this.setChanged();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void setAccessMode(AccessMode accessMode) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setAccessMode(accessMode);
    }

    void setPriority(int priority) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setInsertPriority(priority);
    }

    void setVoidExcess(boolean voidExcess) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setVoidExcess(voidExcess);
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)ContentNames.EXTERNAL_STORAGE);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        return new ExternalStorageContainerMenu(syncId, player, this.filter.getFilterContainer(), (StorageConfigurationContainer)this.configContainer);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

