/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StorageContainerUpgradeRecipe<T extends StorageVariant>
extends ShapelessRecipe {
    private final Set<Item> validSourceContainers;
    private final T[] variants;
    private final T to;

    public StorageContainerUpgradeRecipe(T[] variants, T to, Function<T, ItemLike> containerProvider) {
        super("", CraftingBookCategory.MISC, containerProvider.apply(to).asItem().getDefaultInstance(), StorageContainerUpgradeRecipe.getIngredients(variants, to, containerProvider));
        this.validSourceContainers = StorageContainerUpgradeRecipe.getValidSourceContainers(to, variants, containerProvider);
        this.variants = variants;
        this.to = to;
    }

    private static <T extends StorageVariant> NonNullList<Ingredient> getIngredients(T[] variants, T to, Function<T, ItemLike> containerProvider) {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)Ingredient.of((ItemLike[])((ItemLike[])StorageContainerUpgradeRecipe.getValidSourceContainers(to, variants, containerProvider).toArray(new Item[0]))));
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{to.getStoragePart()}));
        return ingredients;
    }

    public T[] getVariants() {
        return this.variants;
    }

    public T getTo() {
        return this.to;
    }

    private static <T extends StorageVariant> Set<Item> getValidSourceContainers(T destination, T[] variants, Function<T, ItemLike> containerProvider) {
        if (destination.getCapacity() == null) {
            return Set.of();
        }
        return Arrays.stream(variants).filter(variant -> variant.getCapacity() != null && variant.getCapacity() < destination.getCapacity()).map(containerProvider).map(ItemLike::asItem).collect(Collectors.toSet());
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        for (int i = 0; i < input.size(); ++i) {
            ItemStack fromDisk = input.getItem(i);
            Item item = fromDisk.getItem();
            if (!(item instanceof UpgradeableStorageContainer)) continue;
            UpgradeableStorageContainer from = (UpgradeableStorageContainer)item;
            if (!this.validSourceContainers.contains(fromDisk.getItem())) continue;
            ItemStack toDisk = this.getResultItem(provider).copy();
            from.transferTo(fromDisk, toDisk);
            return toDisk;
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(CraftingInput input, Level level) {
        int diskCount = 0;
        int partCount = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack inputStack = input.getItem(i);
            if (this.validSourceContainers.contains(inputStack.getItem())) {
                ++diskCount;
            } else if (inputStack.getItem() == this.to.getStoragePart()) {
                ++partCount;
            }
            if (diskCount != 1 || partCount != 1) continue;
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            Item storagePart;
            ItemStack stack = input.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeableStorageContainer)) continue;
            UpgradeableStorageContainer from = (UpgradeableStorageContainer)item;
            if (!this.validSourceContainers.contains(stack.getItem()) || (storagePart = from.getVariant().getStoragePart()) == null) continue;
            remainingItems.set(i, (Object)storagePart.getDefaultInstance());
        }
        return remainingItems;
    }
}

