/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStorageRepository
implements StorageRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStorageRepository.class);
    private final Map<UUID, StorageInfo> info = new HashMap<UUID, StorageInfo>();
    private final RateLimiter rateLimiter = RateLimiter.create((double)2.0);
    private final Consumer<UUID> storageInfoRequestAcceptor;

    public ClientStorageRepository(Consumer<UUID> storageInfoRequestAcceptor) {
        this.storageInfoRequestAcceptor = CoreValidations.validateNotNull(storageInfoRequestAcceptor, "Storage info request acceptor cannot be null");
    }

    @Override
    public Optional<SerializableStorage> get(UUID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(UUID id, SerializableStorage storage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<SerializableStorage> removeIfEmpty(UUID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(UUID id) {
        throw new UnsupportedOperationException();
    }

    public void setInfo(UUID id, long stored, long capacity) {
        this.info.put(id, new StorageInfo(stored, capacity));
    }

    @Override
    public StorageInfo getInfo(UUID id) {
        this.trySendRequestPacket(id);
        return this.info.getOrDefault(id, StorageInfo.UNKNOWN);
    }

    private void trySendRequestPacket(UUID id) {
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        LOGGER.debug("Sending request info packet for {}", (Object)id);
        this.storageInfoRequestAcceptor.accept(id);
    }

    @Override
    public void markAsChanged() {
        throw new UnsupportedOperationException();
    }
}

