/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.common.security.PlayerSecurityActor;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;

public record SecurityCardBoundPlayer(UUID playerId, String playerName) {
    public static final Codec<SecurityCardBoundPlayer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("playerId").forGetter(SecurityCardBoundPlayer::playerId), (App)Codec.STRING.fieldOf("playerName").forGetter(SecurityCardBoundPlayer::playerName)).apply((Applicative)instance, SecurityCardBoundPlayer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SecurityCardBoundPlayer> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SecurityCardBoundPlayer::playerId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SecurityCardBoundPlayer::playerName, SecurityCardBoundPlayer::new);

    static SecurityCardBoundPlayer of(ServerPlayer player) {
        GameProfile profile = player.getGameProfile();
        return new SecurityCardBoundPlayer(profile.getId(), profile.getName());
    }

    PlayerSecurityActor toSecurityActor() {
        return new PlayerSecurityActor(this.playerId);
    }
}

