/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.detector;

import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.detector.DetectorBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DetectorBlock
extends AbstractDirectionalBlock<Direction>
implements ColorableBlock<DetectorBlock, BaseBlockItem>,
SimpleWaterloggedBlock,
EntityBlock,
BlockItemProvider<BaseBlockItem> {
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    private static final Component HELP = IdentifierUtil.createTranslation("item", "detector.help");
    private static final AbstractBlockEntityTicker<DetectorBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getDetector);
    private static final VoxelShape SHAPE_DOWN = DetectorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    private static final VoxelShape SHAPE_UP = DetectorBlock.box((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH = DetectorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    private static final VoxelShape SHAPE_EAST = DetectorBlock.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = DetectorBlock.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = DetectorBlock.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);
    private final DyeColor color;
    private final MutableComponent name;

    public DetectorBlock(DyeColor color, MutableComponent name) {
        super(BlockConstants.PROPERTIES);
        this.color = color;
        this.name = name;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected DirectionType<Direction> getDirectionType() {
        return DefaultDirectionType.FACE_CLICKED;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    @Override
    public BlockColorMap<DetectorBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getDetector();
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    public MutableComponent getName() {
        return this.name;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)this.getDirection(state);
        if (direction == null) {
            return SHAPE_DOWN;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DetectorBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TICKER.get(level, blockEntityType);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return Boolean.TRUE.equals(state.getValue((Property)POWERED)) ? 15 : 0;
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }

    @Override
    public boolean canAlwaysConnect() {
        return true;
    }
}

