/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.controller;

import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.controller.ControllerBlockEntity;
import com.refinedmods.refinedstorage.common.controller.ControllerBlockEntityTicker;
import com.refinedmods.refinedstorage.common.controller.ControllerEnergyType;
import com.refinedmods.refinedstorage.common.controller.ControllerType;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractControllerBlock<I extends BlockItem>
extends AbstractBaseBlock
implements ColorableBlock<AbstractControllerBlock<I>, I>,
EntityBlock,
BlockItemProvider<I> {
    public static final EnumProperty<ControllerEnergyType> ENERGY_TYPE = EnumProperty.create((String)"energy_type", ControllerEnergyType.class);
    private final MutableComponent name;
    private final ControllerType type;
    private final ControllerBlockEntityTicker ticker;
    private final DyeColor color;

    protected AbstractControllerBlock(ControllerType type, MutableComponent name, ControllerBlockEntityTicker ticker, DyeColor color) {
        super(BlockConstants.PROPERTIES);
        this.type = type;
        this.name = name;
        this.ticker = ticker;
        this.color = color;
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue(ENERGY_TYPE, (Comparable)((Object)ControllerEnergyType.OFF));
    }

    public MutableComponent getName() {
        return this.name;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ENERGY_TYPE});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(this.type, pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return this.ticker.get(level, blockEntityType);
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public boolean canAlwaysConnect() {
        return true;
    }
}

