/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.content;

import com.refinedmods.refinedstorage.common.content.BlockFactory;
import com.refinedmods.refinedstorage.common.content.ColorMap;
import com.refinedmods.refinedstorage.common.content.RegistryCallback;
import com.refinedmods.refinedstorage.common.support.BlockItemProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockColorMap<T extends Block, I extends BlockItem>
extends ColorMap<T> {
    private final BlockFactory<T> blockFactory;
    private final MutableComponent baseName;

    public BlockColorMap(BlockFactory<T> blockFactory, ResourceLocation baseId, MutableComponent baseName, DyeColor defaultColor) {
        super(baseId, defaultColor);
        this.blockFactory = Objects.requireNonNull(blockFactory);
        this.baseName = Objects.requireNonNull(baseName);
    }

    public Optional<InteractionResult> updateColor(BlockState state, ItemStack heldItem, Level level, BlockPos pos, Player player) {
        DyeColor color;
        Item item = heldItem.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            v0 = dye.getDyeColor();
        } else {
            v0 = color = null;
        }
        if (color == null || state.getBlock().equals(this.get(color))) {
            return Optional.empty();
        }
        if (!level.isClientSide()) {
            this.updateColorOnServer(state, heldItem, level, pos, (ServerPlayer)player, color);
        }
        return Optional.of(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
    }

    private void updateColorOnServer(BlockState state, ItemStack heldItem, Level level, BlockPos pos, ServerPlayer player, DyeColor color) {
        Block newBlock = (Block)this.get(color);
        level.setBlockAndUpdate(pos, this.getNewState(newBlock, state));
        if (player.gameMode.getGameModeForPlayer() != GameType.CREATIVE) {
            heldItem.shrink(1);
        }
    }

    public Block[] toArray() {
        return this.values().toArray(new Block[0]);
    }

    private BlockState getNewState(Block newBlock, BlockState oldState) {
        BlockState newState = newBlock.defaultBlockState();
        for (Property property : oldState.getProperties()) {
            if (!newState.hasProperty(property)) continue;
            newState = (BlockState)newState.setValue(property, oldState.getValue(property));
        }
        return newState;
    }

    private MutableComponent getName(DyeColor color) {
        if (color != this.defaultColor) {
            MutableComponent colorTranslation = Component.translatable((String)("color.minecraft." + color.getName()));
            return IdentifierUtil.createTranslation("item", "color_and_item_name", colorTranslation, this.baseName);
        }
        return this.baseName;
    }

    public void registerBlocks(RegistryCallback<Block> callback) {
        this.putAll(color -> callback.register(this.getId((DyeColor)color), () -> this.blockFactory.createBlock((DyeColor)color, this.getName((DyeColor)color))));
    }

    public void registerItems(RegistryCallback<Item> callback) {
        this.registerItems(callback, itemSupplier -> {});
    }

    public void registerItems(RegistryCallback<Item> callback, Consumer<Supplier<I>> acceptor) {
        this.forEach((color, id, block) -> {
            Supplier<BlockItem> itemSupplier = () -> BlockColorMap.lambda$registerItems$3((Supplier)block);
            acceptor.accept(callback.register(id, itemSupplier));
        });
    }

    private static /* synthetic */ BlockItem lambda$registerItems$3(Supplier block) {
        return ((BlockItemProvider)((Block)block.get())).createBlockItem();
    }
}

