/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import java.util.UUID;
import javax.annotation.Nullable;

public class AutocraftingRequest {
    private final UUID id;
    private final ResourceKey resource;
    private final double amount;
    @Nullable
    private Preview preview;
    private long pendingPreviewAmount;

    private AutocraftingRequest(UUID id, ResourceKey resource, double amount) {
        this.id = id;
        this.resource = resource;
        this.amount = amount;
    }

    public static AutocraftingRequest of(ResourceAmount resourceAmount) {
        double d;
        ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof PlatformResourceKey) {
            PlatformResourceKey platformResourceKey = (PlatformResourceKey)resourceKey;
            d = platformResourceKey.getResourceType().getDisplayAmount(resourceAmount.amount());
        } else {
            d = resourceAmount.amount();
        }
        double displayAmount = d;
        return new AutocraftingRequest(UUID.randomUUID(), resourceAmount.resource(), displayAmount);
    }

    boolean sendPreviewRequest(double previewAmount) {
        ResourceKey resourceKey = this.resource;
        if (!(resourceKey instanceof PlatformResourceKey)) {
            return false;
        }
        PlatformResourceKey resourceKey2 = (PlatformResourceKey)resourceKey;
        long normalizedAmount = resourceKey2.getResourceType().normalizeAmount(previewAmount);
        if (normalizedAmount == this.pendingPreviewAmount) {
            return false;
        }
        this.preview = null;
        this.pendingPreviewAmount = normalizedAmount;
        C2SPackets.sendAutocraftingPreviewRequest(this.id, resourceKey2, normalizedAmount);
        return true;
    }

    void previewResponseReceived(Preview previewReceived) {
        this.pendingPreviewAmount = 0L;
        this.preview = previewReceived;
    }

    void sendRequest(double amountRequested, boolean notify) {
        ResourceKey resourceKey = this.resource;
        if (!(resourceKey instanceof PlatformResourceKey)) {
            return;
        }
        PlatformResourceKey resourceKey2 = (PlatformResourceKey)resourceKey;
        long normalizedAmount = resourceKey2.getResourceType().normalizeAmount(amountRequested);
        C2SPackets.sendAutocraftingRequest(this.id, resourceKey2, normalizedAmount, notify);
    }

    UUID getId() {
        return this.id;
    }

    ResourceKey getResource() {
        return this.resource;
    }

    double getAmount() {
        return this.amount;
    }

    @Nullable
    Preview getPreview() {
        return this.preview;
    }

    void clearPreview() {
        this.pendingPreviewAmount = 0L;
        this.preview = null;
    }
}

