/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.monitor;

import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AbstractAutocraftingMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorItemTooltip;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingMonitorListener;
import com.refinedmods.refinedstorage.common.autocrafting.monitor.AutocraftingTaskButton;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class AutocraftingMonitorScreen
extends AbstractBaseScreen<AbstractAutocraftingMonitorContainerMenu>
implements AutocraftingMonitorListener {
    static final int TASK_BUTTON_HEIGHT = 24;
    static final int TASK_BUTTON_WIDTH = 64;
    private static final int ROWS_VISIBLE = 6;
    private static final int COLUMNS = 3;
    private static final int ITEMS_AREA_HEIGHT = 179;
    private static final int ITEM_COLOR = -2368549;
    private static final int PROCESSING_COLOR = -2494985;
    private static final int SCHEDULED_COLOR = -1514038;
    private static final int CRAFTING_COLOR = -5383226;
    private static final int ROW_HEIGHT = 30;
    private static final int ROW_WIDTH = 221;
    private static final ResourceLocation TEXTURE = IdentifierUtil.createIdentifier("textures/gui/autocrafting_monitor.png");
    private static final ResourceLocation ROW = IdentifierUtil.createIdentifier("autocrafting_monitor/row");
    private static final ResourceLocation TASKS = IdentifierUtil.createIdentifier("autocrafting_monitor/tasks");
    private static final MutableComponent CANCEL = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.cancel");
    private static final MutableComponent CANCEL_ALL = IdentifierUtil.createTranslation("gui", "autocrafting_monitor.cancel_all");
    private static final int TASKS_WIDTH = 91;
    private static final int TASKS_HEIGHT = 183;
    private static final int TASKS_INNER_WIDTH = 64;
    private static final int TASKS_INNER_HEIGHT = 168;
    private static final int TASKS_VISIBLE = 7;
    @Nullable
    private ScrollbarWidget taskItemsScrollbar;
    @Nullable
    private ScrollbarWidget taskButtonsScrollbar;
    @Nullable
    private Button cancelButton;
    @Nullable
    private Button cancelAllButton;
    private final List<AutocraftingTaskButton> taskButtons = new ArrayList<AutocraftingTaskButton>();

    public AutocraftingMonitorScreen(AbstractAutocraftingMonitorContainerMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 254;
        this.imageHeight = 231;
    }

    @Override
    protected void init() {
        super.init();
        this.taskItemsScrollbar = new ScrollbarWidget(this.leftPos + 235, this.topPos + 20, ScrollbarWidget.Type.NORMAL, 179);
        this.taskItemsScrollbar.setEnabled(false);
        this.initTaskButtons();
        ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).setListener(this);
        this.getExclusionZones().add(new Rect2i(this.leftPos - 91 + 4, this.topPos, 91, 183));
        int cancelButtonsY = this.topPos + 204;
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CANCEL, button -> ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).cancelCurrentTask()).pos(this.leftPos + 7, cancelButtonsY).size(this.font.width((FormattedText)CANCEL) + 14, 20).build());
        this.cancelButton.active = false;
        this.cancelAllButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CANCEL_ALL, button -> ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).cancelAllTasks()).pos(this.cancelButton.getX() + this.cancelButton.getWidth() + 4, cancelButtonsY).size(this.font.width((FormattedText)CANCEL_ALL) + 14, 20).build());
        this.cancelAllButton.active = false;
        ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).loadCurrentTask();
        if (((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).hasProperty(PropertyTypes.REDSTONE_MODE)) {
            this.addSideButton(new RedstoneModeSideButtonWidget(((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).getProperty(PropertyTypes.REDSTONE_MODE)));
        }
    }

    @Override
    protected int getSideButtonX() {
        return this.leftPos + this.imageWidth + 2;
    }

    private void initTaskButtons() {
        this.taskButtons.clear();
        this.taskButtonsScrollbar = new ScrollbarWidget(this.leftPos - 17 + 4, this.getTaskButtonsInnerY(), ScrollbarWidget.Type.NORMAL, 168);
        this.taskButtonsScrollbar.setListener(value -> {
            int scrollOffset = this.taskButtonsScrollbar.isSmoothScrolling() ? (int)this.taskButtonsScrollbar.getOffset() : (int)this.taskButtonsScrollbar.getOffset() * 24;
            for (int i = 0; i < this.taskButtons.size(); ++i) {
                AutocraftingTaskButton taskButton = this.taskButtons.get(i);
                int y = this.getTaskButtonY(i) - scrollOffset;
                taskButton.setY(y);
                taskButton.visible = this.isTaskButtonVisible(y);
            }
        });
        this.updateTaskButtonsScrollbar();
        for (int i = 0; i < ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).getTasksView().size(); ++i) {
            TaskStatus.TaskInfo taskId = ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).getTasksView().get(i);
            int buttonY = this.getTaskButtonY(i);
            AutocraftingTaskButton button = new AutocraftingTaskButton(this.getTaskButtonsInnerX(), buttonY, taskId, ((AbstractAutocraftingMonitorContainerMenu)this.menu)::setCurrentTaskId, ((AbstractAutocraftingMonitorContainerMenu)this.menu)::getPercentageCompleted);
            button.visible = this.isTaskButtonVisible(buttonY);
            this.taskButtons.add((AutocraftingTaskButton)this.addWidget((GuiEventListener)button));
        }
    }

    private boolean isTaskButtonVisible(int y) {
        if (!((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive()) {
            return false;
        }
        int innerY = this.getTaskButtonsInnerY();
        return y >= innerY - 24 && y <= innerY + 168;
    }

    private int getTaskButtonY(int i) {
        return this.getTaskButtonsInnerY() + i * 24;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.taskItemsScrollbar != null) {
            this.taskItemsScrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.taskButtonsScrollbar != null) {
            this.taskButtonsScrollbar.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        graphics.blitSprite(TASKS, this.leftPos - 91 + 4, this.topPos, 91, 183);
        List<TaskStatus.Item> items = ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).getCurrentItems();
        if (items.isEmpty() || this.taskItemsScrollbar == null || !((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive()) {
            return;
        }
        int x = this.leftPos + 8;
        int y = this.topPos + 20;
        graphics.enableScissor(x, y, x + 221, y + 179);
        int rows = Math.ceilDiv(items.size(), 3);
        for (int i = 0; i < rows; ++i) {
            int scrollOffset = this.taskItemsScrollbar.isSmoothScrolling() ? (int)this.taskItemsScrollbar.getOffset() : (int)this.taskItemsScrollbar.getOffset() * 30;
            int yy = y + i * 30 - scrollOffset;
            this.renderRow(graphics, x, yy, i, items, mouseX, mouseY);
        }
        graphics.disableScissor();
        int tasksInnerX = this.getTaskButtonsInnerX();
        int tasksInnerY = this.getTaskButtonsInnerY();
        graphics.enableScissor(tasksInnerX, tasksInnerY, tasksInnerX + 64, tasksInnerY + 168);
        for (AutocraftingTaskButton taskButton : this.taskButtons) {
            taskButton.render(graphics, mouseX, mouseY, delta);
        }
        graphics.disableScissor();
    }

    private void renderRow(GuiGraphics graphics, int x, int y, int i, List<TaskStatus.Item> items, double mouseX, double mouseY) {
        if (y <= this.topPos + 20 - 30 || y > this.topPos + 20 + 179) {
            return;
        }
        graphics.blitSprite(ROW, x, y, 221, 30);
        for (int column = i * 3; column < Math.min(i * 3 + 3, items.size()); ++column) {
            TaskStatus.Item item = items.get(column);
            int xx = x + column % 3 * 74;
            this.renderItem(graphics, xx, y, item, mouseX, mouseY);
        }
    }

    private static int getItemColor(TaskStatus.Item item, boolean hovering) {
        return hovering ? AutocraftingMonitorScreen.darkenARGB(AutocraftingMonitorScreen.getItemColor(item), 0.1) : AutocraftingMonitorScreen.getItemColor(item);
    }

    private static int getItemColor(TaskStatus.Item item) {
        if (item.processing() > 0L) {
            return -2494985;
        }
        if (item.scheduled() > 0L) {
            return -1514038;
        }
        if (item.crafting() > 0L) {
            return -5383226;
        }
        return -2368549;
    }

    private static int darkenARGB(int argb, double percentage) {
        int alpha = argb >> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        red = (int)Math.max(0.0, (double)red * (1.0 - percentage));
        green = (int)Math.max(0.0, (double)green * (1.0 - percentage));
        blue = (int)Math.max(0.0, (double)blue * (1.0 - percentage));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private void renderItem(GuiGraphics graphics, int x, int y, TaskStatus.Item item, double mouseX, double mouseY) {
        boolean hovering = this.isHovering(x - this.leftPos, y - this.topPos, 73, 29, mouseX, mouseY);
        int color = AutocraftingMonitorScreen.getItemColor(item, hovering);
        if (color != -2368549) {
            graphics.fill(x, y, x + 73, y + 29, color);
        }
        if (item.type() != TaskStatus.ItemType.NORMAL) {
            AutocraftingMonitorScreen.renderItemErrorIcon(graphics, x, y);
        }
        int xx = x + 2;
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(item.resource().getClass());
        int yy = y + 7;
        rendering.render(item.resource(), graphics, xx, yy);
        if (this.isHovering(x - this.leftPos, y - this.topPos, 73, 29, mouseX, mouseY) && this.isHoveringOverItems(mouseX, mouseY)) {
            this.setDeferredTooltip(List.of(new AutocraftingMonitorItemTooltip(item)));
        }
        if (!SmallText.isSmall()) {
            yy -= 2;
        }
        this.renderItemText(graphics, item, rendering, xx += 19, yy);
    }

    private static void renderItemErrorIcon(GuiGraphics graphics, int x, int y) {
        graphics.blitSprite(Sprites.ERROR, x + 73 - 12 - 3, y + 29 - 12 - 3, 12, 12);
    }

    private void renderItemText(GuiGraphics graphics, TaskStatus.Item item, ResourceRendering rendering, int x, int y) {
        int yy = y;
        if (item.stored() > 0L) {
            this.renderItemText(graphics, "stored", rendering, x, yy, item.stored());
            yy += 7;
        }
        if (item.processing() > 0L) {
            this.renderItemText(graphics, "processing", rendering, x, yy, item.processing());
            yy += 7;
        }
        if (item.scheduled() > 0L) {
            this.renderItemText(graphics, "scheduled", rendering, x, yy, item.scheduled());
            yy += 7;
        }
        if (item.crafting() > 0L) {
            this.renderItemText(graphics, "crafting", rendering, x, yy, item.crafting());
        }
    }

    private void renderItemText(GuiGraphics graphics, String type, ResourceRendering rendering, int x, int y, long amount) {
        SmallText.render(graphics, this.font, IdentifierUtil.createTranslation("gui", "autocrafting_monitor." + type, rendering.formatAmount(amount, true)).getVisualOrderText(), x, y, 0x404040, false, 0.5f);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int clickedButton) {
        if (this.taskItemsScrollbar != null && this.taskItemsScrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        if (this.taskButtonsScrollbar != null && this.taskButtonsScrollbar.mouseClicked(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, clickedButton);
    }

    public void mouseMoved(double mx, double my) {
        if (this.taskItemsScrollbar != null) {
            this.taskItemsScrollbar.mouseMoved(mx, my);
        }
        if (this.taskButtonsScrollbar != null) {
            this.taskButtonsScrollbar.mouseMoved(mx, my);
        }
        super.mouseMoved(mx, my);
    }

    public boolean mouseReleased(double mx, double my, int button) {
        if (this.taskItemsScrollbar != null && this.taskItemsScrollbar.mouseReleased(mx, my, button)) {
            return true;
        }
        if (this.taskButtonsScrollbar != null && this.taskButtonsScrollbar.mouseReleased(mx, my, button)) {
            return true;
        }
        return super.mouseReleased(mx, my, button);
    }

    public boolean mouseScrolled(double x, double y, double z, double delta) {
        boolean didTaskItemsScrollbar = this.taskItemsScrollbar != null && this.isHoveringOverItems(x, y) && this.taskItemsScrollbar.mouseScrolled(x, y, z, delta);
        boolean didTaskButtonsScrollbar = !didTaskItemsScrollbar && this.taskButtonsScrollbar != null && this.isHoveringOverTaskButtons(x, y) && this.taskButtonsScrollbar.mouseScrolled(x, y, z, delta);
        return didTaskItemsScrollbar || didTaskButtonsScrollbar || super.mouseScrolled(x, y, z, delta);
    }

    private boolean isHoveringOverItems(double x, double y) {
        return this.isHovering(8, 20, 221, 179, x, y);
    }

    private boolean isHoveringOverTaskButtons(double x, double y) {
        int tasksInnerX = this.getTaskButtonsInnerX() - 1;
        int tasksInnerY = this.getTaskButtonsInnerY() - 1;
        return this.isHovering(tasksInnerX - this.leftPos, tasksInnerY - this.topPos, 80, 170, x, y);
    }

    private int getTaskButtonsInnerY() {
        return this.topPos + 8;
    }

    private int getTaskButtonsInnerX() {
        return this.leftPos - 83 + 4;
    }

    @Override
    public void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    @Override
    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    public void currentTaskChanged(@Nullable TaskStatus taskStatus) {
        this.updateTaskItemsScrollbar(taskStatus);
        this.updateTaskButtonsScrollbar();
        if (this.cancelButton != null) {
            boolean bl = this.cancelButton.active = ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive() && taskStatus != null;
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.active = ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive() && !((AbstractAutocraftingMonitorContainerMenu)this.menu).getTasksView().isEmpty();
        }
        for (AutocraftingTaskButton taskButton : this.taskButtons) {
            taskButton.active = taskStatus == null || !taskButton.getTaskId().equals(taskStatus.info().id());
            taskButton.visible = ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive();
        }
    }

    private void updateTaskButtonsScrollbar() {
        if (this.taskButtonsScrollbar == null) {
            return;
        }
        int totalTaskButtons = ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive() ? ((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).getTasksView().size() - 7 : 0;
        int maxOffset = this.taskButtonsScrollbar.isSmoothScrolling() ? totalTaskButtons * 24 : totalTaskButtons;
        this.taskButtonsScrollbar.setEnabled(maxOffset > 0);
        this.taskButtonsScrollbar.setMaxOffset(maxOffset);
    }

    private void updateTaskItemsScrollbar(@Nullable TaskStatus taskStatus) {
        if (this.taskItemsScrollbar == null) {
            return;
        }
        if (taskStatus == null || !((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).isActive()) {
            this.taskItemsScrollbar.setEnabled(false);
            this.taskItemsScrollbar.setMaxOffset(0.0);
            return;
        }
        int items = taskStatus.items().size();
        int rows = Math.ceilDiv(items, 3) - 6;
        this.taskItemsScrollbar.setMaxOffset(this.taskItemsScrollbar.isSmoothScrolling() ? (double)(rows * 30) : (double)rows);
        this.taskItemsScrollbar.setEnabled(rows > 0);
    }

    @Override
    public void taskAdded(TaskStatus taskStatus) {
        this.updateTaskButtonsScrollbar();
        int buttonY = this.getTaskButtonY(((AbstractAutocraftingMonitorContainerMenu)this.getMenu()).getTasksView().size() - 1);
        AutocraftingTaskButton button = new AutocraftingTaskButton(this.getTaskButtonsInnerX(), buttonY, taskStatus.info(), ((AbstractAutocraftingMonitorContainerMenu)this.menu)::setCurrentTaskId, ((AbstractAutocraftingMonitorContainerMenu)this.menu)::getPercentageCompleted);
        button.visible = this.isTaskButtonVisible(buttonY);
        this.taskButtons.add((AutocraftingTaskButton)this.addWidget((GuiEventListener)button));
    }

    @Override
    public void taskRemoved(TaskId taskId) {
        this.updateTaskButtonsScrollbar();
        this.taskButtons.stream().filter(b -> b.getTaskId().equals(taskId)).findFirst().ifPresent(button -> {
            this.removeWidget((GuiEventListener)button);
            this.taskButtons.remove(button);
        });
        for (int i = 0; i < this.taskButtons.size(); ++i) {
            AutocraftingTaskButton button2 = this.taskButtons.get(i);
            button2.setY(this.getTaskButtonY(i));
            button2.visible = this.isTaskButtonVisible(button2.getY());
        }
    }
}

