/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.network.impl;

import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.ConnectionProvider;
import com.refinedmods.refinedstorage.api.network.Connections;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.NetworkBuilder;
import com.refinedmods.refinedstorage.api.network.impl.NetworkFactory;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class NetworkBuilderImpl
implements NetworkBuilder {
    private static final Comparator<NetworkNodeContainer> LOWEST_PRIORITY_FIRST = Comparator.comparingInt(NetworkNodeContainer::getPriority);
    private static final Comparator<NetworkNodeContainer> HIGHEST_PRIORITY_FIRST = LOWEST_PRIORITY_FIRST.reversed();
    private final NetworkFactory networkFactory;

    public NetworkBuilderImpl(NetworkFactory networkFactory) {
        this.networkFactory = networkFactory;
    }

    @Override
    public boolean initialize(NetworkNodeContainer container, ConnectionProvider connectionProvider) {
        if (container.getNode().getNetwork() != null) {
            return false;
        }
        Connections connections = connectionProvider.findConnections(container, Collections.emptySet());
        CoreValidations.validateEmpty(connections.removedEntries(), "Cannot have removed entries when starting from empty existing connections");
        this.mergeNetworksOfNodes(connectionProvider, container, connections.foundEntries(), false);
        return true;
    }

    private void mergeNetworksOfNodes(ConnectionProvider connectionProvider, NetworkNodeContainer pivot, Set<NetworkNodeContainer> foundEntries, boolean pivotAlreadyHasNetwork) {
        Network pivotNetwork = pivotAlreadyHasNetwork ? CoreValidations.validateNotNull(pivot.getNode().getNetwork(), "Pivot must have network") : this.findPivotNetworkForMerge(connectionProvider, pivot, foundEntries).orElseGet(() -> this.createNetwork(pivot));
        HashSet<Network> mergedNetworks = new HashSet<Network>();
        for (NetworkNodeContainer entry : connectionProvider.sortDeterministically(foundEntries)) {
            Network mergedNetwork;
            NetworkNode entryNode = entry.getNode();
            boolean isNotInPivotNetwork = !pivotNetwork.getComponent(GraphNetworkComponent.class).getContainers().contains(entry);
            if (!isNotInPivotNetwork || (mergedNetwork = this.mergeNetworkOfNode(pivotNetwork, entry, entryNode)) == null) continue;
            mergedNetworks.add(mergedNetwork);
        }
        mergedNetworks.forEach(mn -> mn.merge(pivotNetwork));
    }

    @Nullable
    private Network mergeNetworkOfNode(Network newNetwork, NetworkNodeContainer entry, NetworkNode entryNode) {
        Network oldNetwork = entryNode.getNetwork();
        entryNode.setNetwork(newNetwork);
        newNetwork.addContainer(entry);
        return oldNetwork;
    }

    private Network createNetwork(NetworkNodeContainer container) {
        Network network = this.networkFactory.create();
        container.getNode().setNetwork(network);
        network.addContainer(container);
        return network;
    }

    private Optional<Network> findPivotNetworkForMerge(ConnectionProvider connectionProvider, NetworkNodeContainer addedContainer, Set<NetworkNodeContainer> foundEntries) {
        for (NetworkNodeContainer entry : connectionProvider.sortDeterministically(foundEntries)) {
            Network entryNetwork;
            if (entry == addedContainer || (entryNetwork = entry.getNode().getNetwork()) == null) continue;
            return Optional.of(entryNetwork);
        }
        return Optional.empty();
    }

    @Override
    public void remove(NetworkNodeContainer container, ConnectionProvider connectionProvider) {
        Network network = container.getNode().getNetwork();
        if (network == null) {
            throw new IllegalStateException("Cannot remove node that has no network yet");
        }
        Set<NetworkNodeContainer> containers = network.getComponent(GraphNetworkComponent.class).getContainers();
        NetworkNodeContainer pivot = this.findPivotNodeForRemove(connectionProvider, container, containers);
        if (pivot == null) {
            network.remove();
            container.getNode().setNetwork(null);
            return;
        }
        Connections connections = connectionProvider.findConnections(pivot, containers);
        CoreValidations.validateContains(connections.removedEntries(), container, "The removed container should be present in the removed entries, but isn't");
        this.splitNetworks(connectionProvider, connections.removedEntries(), container);
    }

    @Override
    public void update(NetworkNodeContainer container, ConnectionProvider connectionProvider) {
        Network network = container.getNode().getNetwork();
        if (network == null) {
            throw new IllegalStateException("Cannot update node that has no network yet");
        }
        Set<NetworkNodeContainer> containers = network.getComponent(GraphNetworkComponent.class).getContainers();
        Connections connections = connectionProvider.findConnections(container, containers);
        this.splitNetworks(connectionProvider, connections.removedEntries(), container);
        this.mergeNetworksOfNodes(connectionProvider, container, connections.foundEntries(), true);
    }

    @Nullable
    private NetworkNodeContainer findPivotNodeForRemove(ConnectionProvider connectionProvider, NetworkNodeContainer removedContainer, Set<NetworkNodeContainer> containers) {
        for (NetworkNodeContainer entry : connectionProvider.sortDeterministically(containers)) {
            if (entry.equals(removedContainer)) continue;
            return entry;
        }
        return null;
    }

    private void splitNetworks(ConnectionProvider connectionProvider, Set<NetworkNodeContainer> removedEntries, NetworkNodeContainer removedEntry) {
        Network networkOfRemovedNode = removedEntry.getNode().getNetwork();
        if (networkOfRemovedNode == null) {
            throw new IllegalStateException("Network of removed node cannot be empty");
        }
        connectionProvider.sortDeterministically(removedEntries).stream().sorted(HIGHEST_PRIORITY_FIRST).forEach(e -> {
            if (e.getNode().getNetwork() == null) {
                throw new IllegalStateException("Network of resulting removed node (" + String.valueOf(e.getNode()) + ") cannot be empty");
            }
            e.getNode().getNetwork().removeContainer((NetworkNodeContainer)e);
            e.getNode().setNetwork(null);
        });
        Set<Network> networksResultingOfSplit = connectionProvider.sortDeterministically(removedEntries).stream().filter(e -> !e.equals(removedEntry)).sorted(HIGHEST_PRIORITY_FIRST).map(e -> {
            boolean establishedNetwork = this.initialize((NetworkNodeContainer)e, connectionProvider);
            if (establishedNetwork) {
                return e.getNode().getNetwork();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!networksResultingOfSplit.isEmpty()) {
            networkOfRemovedNode.split(networksResultingOfSplit);
        }
    }
}

