/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

class MutablePatternPlan {
    private final Pattern pattern;
    private final boolean root;
    private final Map<Integer, Map<ResourceKey, Long>> ingredients = new HashMap<Integer, Map<ResourceKey, Long>>();
    private long iterations;

    MutablePatternPlan(Pattern pattern, boolean root) {
        this.pattern = pattern;
        this.root = root;
    }

    void addIterations(long it) {
        this.iterations += it;
    }

    void addUsedIngredient(int ingredientIndex, ResourceKey resource, long amount) {
        Map resources = this.ingredients.computeIfAbsent(ingredientIndex, i -> new LinkedHashMap());
        resources.put(resource, resources.getOrDefault(resource, 0L) + amount);
    }

    MutablePatternPlan copy() {
        MutablePatternPlan copy = new MutablePatternPlan(this.pattern, this.root);
        copy.iterations = this.iterations;
        for (Map.Entry<Integer, Map<ResourceKey, Long>> entry : this.ingredients.entrySet()) {
            LinkedHashMap<ResourceKey, Long> resourcesCopy = new LinkedHashMap<ResourceKey, Long>(entry.getValue());
            copy.ingredients.put(entry.getKey(), resourcesCopy);
        }
        return copy;
    }

    TaskPlan.PatternPlan getPlan() {
        return new TaskPlan.PatternPlan(this.root, this.iterations, this.ingredients.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableMap(((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new))))));
    }
}

