/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.task;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.task.AbstractTaskPattern;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSinkProvider;
import com.refinedmods.refinedstorage.api.autocrafting.task.PatternStepResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskPlan;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskSnapshot;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalTaskPattern
extends AbstractTaskPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalTaskPattern.class);
    private final long originalIterationsRemaining;
    private long iterationsRemaining;

    InternalTaskPattern(Pattern pattern, TaskPlan.PatternPlan plan) {
        super(pattern, plan);
        this.originalIterationsRemaining = plan.iterations();
        this.iterationsRemaining = plan.iterations();
    }

    InternalTaskPattern(TaskSnapshot.PatternSnapshot snapshot) {
        super(snapshot.pattern(), new TaskPlan.PatternPlan(snapshot.root(), Objects.requireNonNull(snapshot.internalPattern()).originalIterationsRemaining(), snapshot.ingredients()));
        this.originalIterationsRemaining = snapshot.internalPattern().originalIterationsRemaining();
        this.iterationsRemaining = snapshot.internalPattern().iterationsRemaining();
    }

    @Override
    PatternStepResult step(MutableResourceList internalStorage, RootStorage rootStorage, ExternalPatternSinkProvider sinkProvider, TaskListener listener) {
        ResourceList iterationInputsSimulated = this.calculateIterationInputs(Action.SIMULATE);
        if (!this.extractAll(iterationInputsSimulated, internalStorage, Action.SIMULATE)) {
            return PatternStepResult.IDLE;
        }
        LOGGER.debug("Stepping {}", (Object)this.pattern);
        ResourceList iterationInputs = this.calculateIterationInputs(Action.EXECUTE);
        this.extractAll(iterationInputs, internalStorage, Action.EXECUTE);
        this.pattern.layout().outputs().forEach(output -> this.returnOutput(internalStorage, rootStorage, (ResourceAmount)output));
        return this.useIteration();
    }

    private void returnOutput(MutableResourceList internalStorage, RootStorage rootStorage, ResourceAmount output) {
        if (this.root) {
            LOGGER.debug("Inserting {}x {} into root storage", (Object)output.amount(), (Object)output.resource());
            long inserted = rootStorage.insert(output.resource(), output.amount(), Action.EXECUTE, Actor.EMPTY);
            if (inserted != output.amount()) {
                long remainder = output.amount() - inserted;
                LOGGER.debug("Inserting overflow {}x {} into internal storage", (Object)remainder, (Object)output.resource());
                internalStorage.add(output.resource(), remainder);
            }
        } else {
            LOGGER.debug("Inserting {}x {} into internal storage", (Object)output.amount(), (Object)output.resource());
            internalStorage.add(output);
        }
    }

    @Override
    void appendStatus(TaskStatusBuilder builder) {
        if (this.iterationsRemaining == 0L) {
            return;
        }
        for (ResourceAmount output : this.pattern.layout().outputs()) {
            builder.crafting(output.resource(), output.amount() * this.iterationsRemaining);
        }
    }

    @Override
    long getWeight() {
        return this.originalIterationsRemaining;
    }

    @Override
    double getPercentageCompleted() {
        long iterationsCompleted = this.originalIterationsRemaining - this.iterationsRemaining;
        return (double)iterationsCompleted / (double)this.originalIterationsRemaining;
    }

    protected PatternStepResult useIteration() {
        --this.iterationsRemaining;
        LOGGER.debug("Stepped {} with {} iterations remaining", (Object)this.pattern, (Object)this.iterationsRemaining);
        return this.iterationsRemaining == 0L ? PatternStepResult.COMPLETED : PatternStepResult.RUNNING;
    }

    @Override
    TaskSnapshot.PatternSnapshot createSnapshot() {
        return new TaskSnapshot.PatternSnapshot(this.root, this.pattern, this.ingredients, new TaskSnapshot.InternalPatternSnapshot(this.originalIterationsRemaining, this.iterationsRemaining), null);
    }
}

