/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.Amount;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.NumberOverflowDuringCalculationException;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.PatternCycleDetectedException;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewBuilder;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;

public class PreviewCraftingCalculatorListener
implements CraftingCalculatorListener<PreviewBuilder> {
    private PreviewBuilder builder;

    public PreviewCraftingCalculatorListener(PreviewBuilder builder) {
        this.builder = builder;
    }

    public static Preview calculatePreview(CraftingCalculator calculator, ResourceKey resource, long amount, CancellationToken cancellationToken) {
        PreviewCraftingCalculatorListener listener = new PreviewCraftingCalculatorListener(PreviewBuilder.create());
        try {
            calculator.calculate(resource, amount, listener, cancellationToken);
        }
        catch (PatternCycleDetectedException e) {
            return new Preview(PreviewType.CYCLE_DETECTED, Collections.emptyList(), e.getPattern().layout().outputs());
        }
        catch (NumberOverflowDuringCalculationException e) {
            return new Preview(PreviewType.OVERFLOW, Collections.emptyList(), Collections.emptyList());
        }
        return listener.buildPreview();
    }

    @Override
    public CraftingCalculatorListener<PreviewBuilder> childCalculationStarted(Pattern childPattern, ResourceKey resource, Amount amount) {
        PreviewBuilder copy = this.builder.copy();
        copy.addToCraft(resource, amount.getTotal());
        return new PreviewCraftingCalculatorListener(copy);
    }

    @Override
    public void childCalculationCompleted(CraftingCalculatorListener<PreviewBuilder> childListener) {
        this.builder = childListener.getData();
    }

    @Override
    public void childCalculationCancelled(CraftingCalculatorListener<PreviewBuilder> childListener) {
        this.builder.cancelled();
    }

    @Override
    public void ingredientsExhausted(ResourceKey resource, long amount) {
        this.builder.addMissing(resource, amount);
    }

    @Override
    public void ingredientUsed(Pattern ingredientPattern, int ingredientIndex, ResourceKey resource, long amount) {
    }

    @Override
    public void ingredientExtractedFromStorage(ResourceKey resource, long amount) {
        this.builder.addAvailable(resource, amount);
    }

    @Override
    public PreviewBuilder getData() {
        return this.builder;
    }

    private Preview buildPreview() {
        return this.builder.build();
    }
}

