/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingState;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Arrays;
import java.util.Optional;

class IngredientState {
    private final long amount;
    private final ResourceKey[] possibilities;
    private int pos;

    IngredientState(Ingredient ingredient, CraftingState state) {
        this.amount = ingredient.amount();
        this.possibilities = new ResourceKey[ingredient.inputs().size()];
        for (int i = 0; i < ingredient.inputs().size(); ++i) {
            ResourceKey resource;
            this.possibilities[i] = resource = ingredient.inputs().get(i);
        }
        Arrays.sort(this.possibilities, state.storageSorter());
        Arrays.sort(this.possibilities, state.internalStorageSorter());
    }

    ResourceKey get() {
        return this.possibilities[this.pos];
    }

    long amount() {
        return this.amount;
    }

    Optional<ResourceKey> cycle() {
        if (this.pos + 1 >= this.possibilities.length) {
            return Optional.empty();
        }
        ++this.pos;
        return Optional.of(this.get());
    }
}

