/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.calculation;

import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;

public record Amount(long iterations, long amountPerIteration) {
    public Amount {
        CoreValidations.validateLargerThanZero(iterations, "Iterations");
        CoreValidations.validateLargerThanZero(amountPerIteration, "Amount per iteration");
    }

    public long getTotal() {
        return this.iterations * this.amountPerIteration;
    }

    static Amount of(Pattern pattern, ResourceKey resource, long requestedAmount) {
        long amountPerIteration = pattern.layout().outputs().stream().filter(output -> output.resource().equals(resource)).mapToLong(ResourceAmount::amount).sum();
        long iterations = (requestedAmount - 1L) / amountPerIteration + 1L;
        return new Amount(iterations, amountPerIteration);
    }
}

