/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.PatternType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.4.12")
public class PatternBuilder {
    private final PatternType type;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final List<ResourceAmount> outputs = new ArrayList<ResourceAmount>();

    private PatternBuilder(PatternType type) {
        this.type = type;
    }

    public static PatternBuilder pattern() {
        return PatternBuilder.pattern(PatternType.INTERNAL);
    }

    public static PatternBuilder pattern(PatternType type) {
        return new PatternBuilder(type);
    }

    public IngredientBuilder ingredient(long amount) {
        return new IngredientBuilder(amount);
    }

    public PatternBuilder ingredient(ResourceKey input, long amount) {
        this.ingredients.add(new Ingredient(amount, List.of(input)));
        return this;
    }

    public PatternBuilder output(ResourceKey output, long amount) {
        this.outputs.add(new ResourceAmount(output, amount));
        return this;
    }

    public PatternLayout buildLayout() {
        return new PatternLayout(this.ingredients, this.outputs, this.type);
    }

    public Pattern build() {
        return new Pattern(UUID.randomUUID(), this.buildLayout());
    }

    public class IngredientBuilder {
        private final long amount;
        private final List<ResourceKey> inputs = new ArrayList<ResourceKey>();

        private IngredientBuilder(long amount) {
            this.amount = amount;
        }

        public IngredientBuilder input(ResourceKey input) {
            this.inputs.add(input);
            return this;
        }

        public PatternBuilder end() {
            PatternBuilder.this.ingredients.add(new Ingredient(this.amount, this.inputs));
            return PatternBuilder.this;
        }
    }
}

