/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.outline;

import com.heaser.pipeconnector.client.outline.PipeConnectorRenderType;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockEqualsChecker;
import com.heaser.pipeconnector.compatibility.CompatibilityBlockGetter;
import com.heaser.pipeconnector.utils.BuildParameters;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.NodeParameter;
import com.heaser.pipeconnector.utils.PipeConnectorUtils;
import com.heaser.pipeconnector.utils.PreviewInfo;
import com.heaser.pipeconnector.utils.TagUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PreviewDrawer {
    public HashSet<PreviewInfo> previewMap = new HashSet();
    private BuildParameters cachedParameters = new BuildParameters();

    public void handleOnRenderLevel(PoseStack pose, MultiBufferSource buffer, Player player) {
        ItemStack heldItem = GeneralUtils.heldPipeConnector(player);
        if (heldItem == null) {
            return;
        }
        if (this.shouldUpdatePreview(heldItem)) {
            Level currentLevel = player.level();
            this.previewMap = this.getNewPreview(heldItem, currentLevel, player);
        }
        this.draw(pose, buffer, player, heldItem);
    }

    private HashSet<PreviewInfo> getNewPreview(ItemStack pipeConnector, Level currentLevel, Player player) {
        List<NodeParameter> nodes = TagUtils.getNodesFromStack(pipeConnector);
        if (nodes.size() < 2) {
            return new HashSet<PreviewInfo>();
        }
        int depth = TagUtils.getDepthFromStack(pipeConnector);
        boolean utilizeExitingPipes = TagUtils.getUtilizeExistingPipes(pipeConnector);
        return PipeConnectorUtils.getBlockPosSet(PipeConnectorUtils.getBlockPosMap(nodes, depth, currentLevel, TagUtils.getBridgeType(pipeConnector), CompatibilityBlockGetter.getInstance().getBlock(player.getOffhandItem()), player.getOffhandItem(), utilizeExitingPipes, player));
    }

    private void draw(PoseStack pose, MultiBufferSource buffer, Player player, ItemStack pipeConnector) {
        VertexConsumer builder = buffer.getBuffer(PipeConnectorRenderType.LINES_NO_DEPTH_TEST);
        Vec3 offset = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        for (PreviewInfo previewInfo : this.previewMap) {
            AABB aabb = new AABB(previewInfo.pos).move(-offset.x, -offset.y, -offset.z);
            if (previewInfo.isNode(pipeConnector)) {
                LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                continue;
            }
            if (GeneralUtils.isNotBreakable(player.level(), previewInfo.pos) || GeneralUtils.hasInventoryCapabilities(player.level(), previewInfo.pos)) {
                LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                continue;
            }
            if (GeneralUtils.isVoidableBlock(player.level(), previewInfo.pos)) {
                LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                continue;
            }
            CompatibilityBlockEqualsChecker.getInstance();
            if (CompatibilityBlockEqualsChecker.isBlockStateSpecificBlock(previewInfo.pos, CompatibilityBlockGetter.getInstance().getBlock(player.getOffhandItem()), player.getOffhandItem(), player.level())) {
                LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)0.87f, (float)0.25f, (float)0.87f, (float)0.5f);
                continue;
            }
            LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)builder, (AABB)aabb, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        }
    }

    private boolean shouldUpdatePreview(ItemStack pipeConnector) {
        boolean shouldUpdate = false;
        BuildParameters newParameters = new BuildParameters(pipeConnector);
        if (!this.cachedParameters.equals(newParameters)) {
            shouldUpdate = true;
            this.cachedParameters = newParameters;
        }
        return shouldUpdate;
    }
}

