/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class TerminalStorageState {
    public static final String SETTING_TAB = "tab";
    public static final String SETTING_SEARCH = "search";
    public static final String SETTING_BUTTON = "button";
    public static final String PLAYER_TAG_DEFAULT_KEY = "integratedterminals:terminalStorageStateDefault";
    private CompoundTag tag;
    private IDirtyMarkListener dirtyMarkListener;

    public TerminalStorageState(IDirtyMarkListener dirtyMarkListener) {
        this(new CompoundTag(), dirtyMarkListener);
    }

    public TerminalStorageState(CompoundTag tag, IDirtyMarkListener dirtyMarkListener) {
        this.tag = tag;
        this.dirtyMarkListener = dirtyMarkListener;
    }

    public void setDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListener = dirtyMarkListener;
    }

    protected void markDirty() {
        this.dirtyMarkListener.onDirty();
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
        this.markDirty();
    }

    public String getTab() {
        return this.tag.getString(SETTING_TAB);
    }

    public boolean hasTab() {
        return this.tag.contains(SETTING_TAB, 8);
    }

    public void setTab(@Nullable String tab) {
        if (tab != null) {
            this.tag.putString(SETTING_TAB, tab);
        } else {
            this.tag.remove(SETTING_TAB);
        }
        this.markDirty();
    }

    public String getSearch(String tab, int channel) {
        return this.tag.getString("search_" + tab + "_" + channel);
    }

    public boolean hasSearch(String tab, int channel) {
        return this.tag.contains("search_" + tab + "_" + channel, 8);
    }

    public void setSearch(String tab, int channel, @Nullable String search) {
        if (tab != null) {
            this.tag.putString("search_" + tab + "_" + channel, search);
        } else {
            this.tag.remove("search_" + tab + "_" + channel);
        }
        this.markDirty();
    }

    public Tag getButton(String tab, String buttonName) {
        return this.tag.get("button_" + tab + "_" + buttonName);
    }

    public boolean hasButton(String tab, String buttonName) {
        return this.tag.contains("button_" + tab + "_" + buttonName);
    }

    public void setButton(String tab, String buttonName, @Nullable Tag button) {
        if (button != null) {
            this.tag.put("button_" + tab + "_" + buttonName, button);
        } else {
            this.tag.remove(SETTING_TAB);
        }
        this.markDirty();
    }

    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeNbt((Tag)this.tag);
    }

    public static TerminalStorageState readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        return new TerminalStorageState(packetBuffer.readNbt(), () -> {});
    }

    public static void setPlayerDefault(Player playerEntity, TerminalStorageState state) {
        playerEntity.getPersistentData().put(PLAYER_TAG_DEFAULT_KEY, (Tag)state.getTag().copy());
    }

    public static TerminalStorageState getPlayerDefault(Player playerEntity, IDirtyMarkListener dirtyMarkListener) {
        if (playerEntity.getPersistentData().contains(PLAYER_TAG_DEFAULT_KEY)) {
            return new TerminalStorageState(playerEntity.getPersistentData().getCompound(PLAYER_TAG_DEFAULT_KEY), dirtyMarkListener);
        }
        return new TerminalStorageState(dirtyMarkListener);
    }
}

