/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingPlanStatic;

public class TerminalCraftingPlanFlatStatic<I>
implements ITerminalCraftingPlanFlat<I> {
    private final I id;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private final List<Entry> entries;
    private TerminalCraftingJobStatus status;
    private TerminalCraftingPlanStatic.Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanFlatStatic(I id, List<Entry> entries, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, TerminalCraftingPlanStatic.Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.entries = entries;
        this.outputs = outputs;
        this.status = status;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<Entry> getEntries() {
        return this.entries;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    public TerminalCraftingPlanStatic.Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.getUnlocalizedLabelOverride() == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    public static <I> CompoundTag serialize(HolderLookup.Provider lookupProvider, TerminalCraftingPlanFlatStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        CompoundTag tag = new CompoundTag();
        tag.put("id", handler.serializeCraftingJobId(plan.getId()));
        ListTag entries = new ListTag();
        for (Entry entry : plan.getEntries()) {
            entries.add((Object)Entry.serialize(lookupProvider, entry));
        }
        tag.put("entries", (Tag)entries);
        ListTag outputs = new ListTag();
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            outputs.add((Object)IPrototypedIngredient.serialize((HolderLookup.Provider)lookupProvider, (IPrototypedIngredient)((PrototypedIngredient)output)));
        }
        tag.put("outputs", (Tag)outputs);
        tag.putInt("status", plan.getStatus().ordinal());
        tag.putInt("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            tag.putString("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        tag.putLong("tickDuration", plan.getTickDuration());
        tag.putInt("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.putString("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanFlatStatic<I> deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.contains("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.contains("entries", 9)) {
            throw new IllegalArgumentException("Could not find a entries entry in the given tag");
        }
        if (!tag.contains("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.contains("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.contains("label", 3)) {
            throw new IllegalArgumentException("Could not find a label entry in the given tag");
        }
        if (!tag.contains("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.contains("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.get("id"));
        ListTag entriesTag = tag.getList("entries", 10);
        ArrayList entries = Lists.newArrayListWithExpectedSize((int)entriesTag.size());
        for (Tag nbtBase : entriesTag) {
            entries.add(Entry.deserialize(lookupProvider, (CompoundTag)nbtBase));
        }
        ListTag outputsTag = tag.getList("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.size());
        for (Tag nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((HolderLookup.Provider)lookupProvider, (CompoundTag)((CompoundTag)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.getInt("status")];
        TerminalCraftingPlanStatic.Label label = TerminalCraftingPlanStatic.Label.values()[tag.getInt("label")];
        String unlocalizedLabelOverride = null;
        if (tag.contains("unlocalizedLabelOverride")) {
            unlocalizedLabelOverride = tag.getString("unlocalizedLabelOverride");
        }
        long tickDuration = tag.getLong("tickDuration");
        int channel = tag.getInt("channel");
        String initiatorName = null;
        if (tag.contains("initiatorName", 8)) {
            initiatorName = tag.getString("initiatorName");
        }
        TerminalCraftingPlanFlatStatic<I> plan = new TerminalCraftingPlanFlatStatic<I>(id, entries, outputs, status, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static class Entry
    implements ITerminalCraftingPlanFlat.IEntry {
        private final IPrototypedIngredient<?, ?> instance;
        private long quantityToCraft;
        private long quantityCrafting;
        private long quantityInStorage;
        private long quantityMissing;

        public Entry(IPrototypedIngredient<?, ?> instance, long quantityToCraft, long quantityCrafting, long quantityInStorage, long quantityMissing) {
            this.instance = instance;
            this.quantityToCraft = quantityToCraft;
            this.quantityCrafting = quantityCrafting;
            this.quantityInStorage = quantityInStorage;
            this.quantityMissing = quantityMissing;
        }

        public Entry(IPrototypedIngredient<?, ?> instance) {
            this(instance, 0L, 0L, 0L, 0L);
        }

        @Override
        public IPrototypedIngredient<?, ?> getInstance() {
            return this.instance;
        }

        @Override
        public long getQuantityToCraft() {
            return this.quantityToCraft;
        }

        public void setQuantityToCraft(long quantityToCraft) {
            this.quantityToCraft = quantityToCraft;
        }

        @Override
        public long getQuantityCrafting() {
            return this.quantityCrafting;
        }

        public void setQuantityCrafting(long quantityCrafting) {
            this.quantityCrafting = quantityCrafting;
        }

        @Override
        public long getQuantityInStorage() {
            return this.quantityInStorage;
        }

        public void setQuantityInStorage(long quantityInStorage) {
            this.quantityInStorage = quantityInStorage;
        }

        @Override
        public long getQuantityMissing() {
            return this.quantityMissing;
        }

        public void setQuantityMissing(long quantityMissing) {
            this.quantityMissing = quantityMissing;
        }

        public static CompoundTag serialize(HolderLookup.Provider lookupProvider, Entry entry) {
            CompoundTag tag = new CompoundTag();
            tag.put("instance", (Tag)IPrototypedIngredient.serialize((HolderLookup.Provider)lookupProvider, entry.getInstance()));
            tag.putLong("quantityToCraft", entry.getQuantityToCraft());
            tag.putLong("quantityCrafting", entry.getQuantityCrafting());
            tag.putLong("quantityInStorage", entry.getQuantityInStorage());
            tag.putLong("quantityMissing", entry.getQuantityMissing());
            return tag;
        }

        public static Entry deserialize(HolderLookup.Provider lookupProvider, CompoundTag tag) {
            if (!tag.contains("instance", 10)) {
                throw new IllegalArgumentException("Could not find a instance entry in the given tag");
            }
            if (!tag.contains("quantityToCraft", 4)) {
                throw new IllegalArgumentException("Could not find a quantityToCraft entry in the given tag");
            }
            if (!tag.contains("quantityCrafting", 4)) {
                throw new IllegalArgumentException("Could not find a quantityCrafting entry in the given tag");
            }
            if (!tag.contains("quantityInStorage", 4)) {
                throw new IllegalArgumentException("Could not find a quantityInStorage entry in the given tag");
            }
            if (!tag.contains("quantityMissing", 4)) {
                throw new IllegalArgumentException("Could not find a quantityMissing entry in the given tag");
            }
            PrototypedIngredient instance = IPrototypedIngredient.deserialize((HolderLookup.Provider)lookupProvider, (CompoundTag)tag.getCompound("instance"));
            long quantityToCraft = tag.getLong("quantityToCraft");
            long quantityCrafting = tag.getLong("quantityCrafting");
            long quantityInStorage = tag.getLong("quantityInStorage");
            long quantityMissing = tag.getLong("quantityMissing");
            return new Entry((IPrototypedIngredient<?, ?>)instance, quantityToCraft, quantityCrafting, quantityInStorage, quantityMissing);
        }
    }
}

