/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import tfar.craftingstation.init.ModBlockEntityTypes;
import tfar.craftingstation.menu.CraftingStationMenu;

public class CraftingStationBlockEntity
extends BlockEntity
implements MenuProvider {
    public SimpleContainer input;
    private Component customName;
    protected Direction currentContainer = Direction.DOWN;

    public CraftingStationBlockEntity(BlockPos pPos, BlockState pState) {
        super(ModBlockEntityTypes.crafting_station, pPos, pState);
        this.input = new SimpleContainer(9){

            public void setChanged() {
                super.setChanged();
                CraftingStationBlockEntity.this.setChanged();
            }

            public void fromTag(ListTag pContainerNbt, HolderLookup.Provider pRegistries) {
                this.items.clear();
                for (int i = 0; i < pContainerNbt.size(); ++i) {
                    ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)pContainerNbt.getCompound(i));
                    this.items.set(i, (Object)itemstack);
                }
            }

            public ListTag createTag(HolderLookup.Provider pLevelRegistry) {
                ListTag listtag = new ListTag();
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    ItemStack itemstack = this.getItem(i);
                    listtag.add((Object)itemstack.saveOptional(pLevelRegistry));
                }
                return listtag;
            }
        };
    }

    public void setCurrentContainer(Direction currentContainer) {
        this.currentContainer = currentContainer;
        this.setChanged();
    }

    public Direction getCurrentContainer() {
        return this.currentContainer;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        ListTag compound = this.input.createTag(pRegistries);
        tag.put("inv", (Tag)compound);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)pRegistries));
        }
        tag.putInt("dir", this.currentContainer.ordinal());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        ListTag invTag = tag.getList("inv", 10);
        this.input.fromTag(invTag, pRegistries);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)pRegistries);
        }
        this.currentContainer = Direction.values()[tag.getInt("dir")];
        super.loadAdditional(tag, pRegistries);
    }

    public Component getDisplayName() {
        return this.getCustomName() != null ? this.getCustomName() : Component.translatable((String)"title.crafting_station");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new CraftingStationMenu(id, playerInventory, this.input, this.worldPosition);
    }

    public void setCustomName(Component pName) {
        this.customName = pName;
    }

    public Component getCustomName() {
        return this.customName;
    }

    public void setChanged() {
        super.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

