/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integratedcrafting.RegistryEntries;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class ContainerPartInterfaceCrafting
extends ContainerMultipart<PartTypeInterfaceCrafting, PartTypeInterfaceCrafting.State> {
    private final List<Integer> readSlotValidIds;
    private final List<Integer> readSlotErrorIds;

    public ContainerPartInterfaceCrafting(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleInventory(packetBuffer.readInt(), 1), Optional.empty(), Optional.empty(), (PartTypeInterfaceCrafting)PartHelpers.readPart((FriendlyByteBuf)packetBuffer));
    }

    public ContainerPartInterfaceCrafting(int id, Inventory playerInventory, Container inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, PartTypeInterfaceCrafting partType) {
        super((MenuType)RegistryEntries.CONTAINER_INTERFACE_CRAFTING.get(), id, playerInventory, inventory, target, partContainer, (IPartType)partType);
        this.addInventory(inventory, 0, 8, 22, 1, inventory.getContainerSize());
        this.addPlayerInventory(this.player.getInventory(), 8, 59);
        this.getPartState().ifPresent(p -> p.setLastPlayer(this.player));
        this.readSlotValidIds = Lists.newArrayList();
        this.readSlotErrorIds = Lists.newArrayList();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            this.readSlotValidIds.add(this.getNextValueId());
            this.readSlotErrorIds.add(this.getNextValueId());
        }
        if (!this.player.getCommandSenderWorld().isClientSide()) {
            this.putButtonAction(ContainerMultipartAspects.BUTTON_SETTINGS, (s, containerExtended) -> PartHelpers.openContainerPartSettings((ServerPlayer)((ServerPlayer)this.player), (PartPos)((PartTarget)target.get()).getCenter(), (IPartType)partType));
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.getPartState().ifPresent(partState -> {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readSlotValidIds.get(i), (boolean)partState.isRecipeSlotValid(i));
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readSlotErrorIds.get(i), (MutableComponent)partState.getRecipeSlotUnlocalizedMessage(i));
            }
        });
    }

    public boolean isRecipeSlotValid(int slot) {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.readSlotValidIds.get(slot));
    }

    @Nullable
    public Component getRecipeSlotUnlocalizedMessage(int slot) {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.readSlotErrorIds.get(slot));
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        if (inventory instanceof SimpleInventory) {
            return new SlotVariable(this, inventory, index, x, y){

                public boolean mayPlace(ItemStack itemStack) {
                    IVariableFacade variableFacade = ((ItemVariable)RegistryEntries.ITEM_VARIABLE.get()).getVariableFacade(ValueDeseralizationContext.ofAllEnabled(), itemStack);
                    return variableFacade != null && ValueHelpers.correspondsTo((IValueType)variableFacade.getOutputType(), (IValueType)ValueTypes.OBJECT_RECIPE) && super.mayPlace(itemStack);
                }
            };
        }
        return super.createNewSlot(inventory, index, x, y);
    }

    public void onDirty() {
    }
}

