/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import reliquary.items.ItemBase;
import reliquary.util.RandHelper;

public class SalamanderEyeItem
extends ItemBase {
    public SalamanderEyeItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || level.getGameTime() % 2L != 0L) {
            return;
        }
        if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == this || player.getItemInHand(InteractionHand.OFF_HAND).getItem() == this) {
            this.doFireballEffect(player);
            this.doExtinguishEffect(player);
        }
    }

    private void doExtinguishEffect(Player player) {
        if (player.isOnFire()) {
            player.clearFire();
        }
        BlockPos.betweenClosed((BlockPos)player.blockPosition().offset(-3, -3, -3), (BlockPos)player.blockPosition().offset(3, 3, 3)).forEach(pos -> {
            if (player.level().getBlockState(pos).getBlock() instanceof BaseFireBlock) {
                player.level().setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                player.level().playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.8f);
            }
        });
    }

    private void doFireballEffect(Player player) {
        List projectiles = player.level().getEntitiesOfClass(Projectile.class, player.getBoundingBox().inflate(5.0), projectile -> projectile.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE));
        for (Projectile projectile2 : projectiles) {
            if (player.distanceTo((Entity)projectile2) < 4.0f) {
                projectile2.discard();
            }
            projectile2.deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true);
            player.level().playLocalSound(projectile2.getX(), projectile2.getY(), projectile2.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.8f, false);
        }
        List blazeFireballs = player.level().getEntitiesOfClass(SmallFireball.class, player.getBoundingBox().inflate(3.0));
        for (SmallFireball fireball : blazeFireballs) {
            for (int particles = 0; particles < 4; ++particles) {
                player.level().addParticle((ParticleOptions)DustParticleOptions.REDSTONE, fireball.getX(), fireball.getY(), fireball.getZ(), 0.0, 1.0, 1.0);
            }
            player.level().playLocalSound(fireball.getX(), fireball.getY(), fireball.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.level().random) * 0.8f, false);
            fireball.discard();
        }
    }
}

