/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerDeathHandler;
import reliquary.handler.IPlayerHurtHandler;
import reliquary.init.ModItems;
import reliquary.items.AngelicFeatherItem;
import reliquary.network.SpawnPhoenixDownParticlesPayload;
import reliquary.reference.Config;
import reliquary.util.EntityHelper;
import reliquary.util.InventoryHelper;
import reliquary.util.PlayerInventoryProvider;

public class PhoenixDownItem
extends AngelicFeatherItem {
    public PhoenixDownItem() {
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(this){

            @Override
            public boolean canApply(Player player, LivingIncomingDamageEvent event) {
                return event.getSource() == player.damageSources().fall() && player.getHealth() > (float)Math.round(event.getAmount()) && player.getFoodData().getFoodLevel() > 0 && InventoryHelper.playerHasItem(player, ModItems.PHOENIX_DOWN.get());
            }

            @Override
            public boolean apply(Player player, LivingIncomingDamageEvent event) {
                float hungerDamage = event.getAmount() * ((float)((Integer)Config.COMMON.items.phoenixDown.hungerCostPercent.get()).intValue() / 100.0f);
                player.causeFoodExhaustion(hungerDamage);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGH;
            }
        });
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(this){

            @Override
            public boolean canApply(Player player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, ModItems.PHOENIX_DOWN.get());
            }

            @Override
            public boolean apply(Player player, LivingDeathEvent event) {
                PhoenixDownItem.revertPhoenixDownToAngelicFeather(player);
                float amountHealed = player.getMaxHealth() * (float)((Integer)Config.COMMON.items.phoenixDown.healPercentageOfMaxLife.get()).intValue() / 100.0f;
                player.setHealth(amountHealed);
                if (Boolean.TRUE.equals(Config.COMMON.items.phoenixDown.removeNegativeStatus.get())) {
                    EntityHelper.removeNegativeStatusEffects((LivingEntity)player);
                }
                if (event.getSource() == player.damageSources().lava() && Boolean.TRUE.equals(Config.COMMON.items.phoenixDown.giveTemporaryFireResistanceIfFireDamageKilledYou.get())) {
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
                }
                if (event.getSource() == player.damageSources().drown() && Boolean.TRUE.equals(Config.COMMON.items.phoenixDown.giveTemporaryWaterBreathingIfDrowningKilledYou.get())) {
                    player.setAirSupply(10);
                    player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0));
                }
                if (Boolean.TRUE.equals(Config.COMMON.items.phoenixDown.giveTemporaryDamageResistance.get())) {
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 1));
                }
                if (Boolean.TRUE.equals(Config.COMMON.items.phoenixDown.giveTemporaryRegeneration.get())) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 1));
                }
                PhoenixDownItem.spawnPhoenixResurrectionParticles(player);
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    private static void revertPhoenixDownToAngelicFeather(Player player) {
        PlayerInventoryProvider.get().swapFirstFoundItemInPlayerInventoryHandlers(player, ModItems.PHOENIX_DOWN.get(), new ItemStack((ItemLike)ModItems.ANGELIC_FEATHER.get()));
    }

    private static void spawnPhoenixResurrectionParticles(Player player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SpawnPhoenixDownParticlesPayload(player.position()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

