/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.items.IItemHandler;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItem;
import reliquary.init.ModDataComponents;
import reliquary.items.ToggleableItem;
import reliquary.items.util.ICuriosItem;
import reliquary.items.util.IScrollableItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.PlayerInventoryProvider;
import reliquary.util.TooltipBuilder;
import reliquary.util.XpHelper;

public class HeroMedallionItem
extends ToggleableItem
implements IPedestalActionItem,
IScrollableItem,
ICuriosItem {
    public HeroMedallionItem() {
        super(new Item.Properties().durability(0).setNoRepair().rarity(Rarity.EPIC));
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENABLED, (Object)false);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    protected void addMoreInformation(ItemStack medallion, @Nullable HolderLookup.Provider registries, TooltipBuilder tooltipBuilder) {
        int experience = this.getExperience(medallion);
        int levels = XpHelper.getLevelForExperience(experience);
        int remainingExperience = experience - XpHelper.getExperienceForLevel(levels);
        tooltipBuilder.data(this, ".tooltip2", levels, remainingExperience);
        tooltipBuilder.description(this, ".tooltip.drain_levels", Component.literal((String)String.valueOf(this.getDrainXpLevels(medallion))).withStyle(ChatFormatting.RED));
        if (this.isEnabled(medallion)) {
            tooltipBuilder.absorbActive((Component)Component.translatable((String)"tooltip.reliquary.xp").withStyle(ChatFormatting.GREEN));
            tooltipBuilder.description(this, ".tooltip.fill_stop_level", Component.literal((String)String.valueOf(this.getStopAtXpLevel(medallion))).withStyle(ChatFormatting.GREEN));
        } else {
            tooltipBuilder.absorb();
        }
        tooltipBuilder.description(this, ".tooltip.scroll_to_change", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (level.isClientSide || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || !this.isEnabled(stack) || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (!player.isUsingItem() || player.getUseItem() != stack) {
            this.drainExperienceLevel(stack, player);
        }
        this.repairItemsInPlayersInventory(stack, player);
    }

    private void repairItemsInPlayersInventory(ItemStack heroMedallion, Player player) {
        long cooldownTime = (Long)heroMedallion.getOrDefault(ModDataComponents.COOLDOWN_TIME, (Object)0L);
        if (cooldownTime > player.level().getGameTime()) {
            return;
        }
        heroMedallion.set(ModDataComponents.COOLDOWN_TIME, (Object)(player.level().getGameTime() + (long)((Integer)Config.COMMON.items.heroMedallion.repairCoolDown.get()).intValue()));
        PlayerInventoryProvider.get().runOnPlayerInventoryHandlers(player, stack -> {
            if (this.canRepairWithXp((ItemStack)stack)) {
                this.repairItemWithXp(heroMedallion, (ItemStack)stack);
            }
        });
    }

    private void drainExperienceLevel(ItemStack stack, Player player) {
        int totalPlayerExperience = XpHelper.getTotalPlayerExperience(player);
        int previousPlayerLevel = XpHelper.getLevelForExperience(totalPlayerExperience) - 1;
        int experiencePoints = player.isCreative() ? 100 : totalPlayerExperience - XpHelper.getExperienceForLevel(Math.max(this.getStopAtXpLevel(stack), previousPlayerLevel));
        if ((experiencePoints = Math.min(experiencePoints, Integer.MAX_VALUE - this.getExperience(stack))) > 0) {
            if (!player.isCreative()) {
                this.decreasePlayerExperience(player, experiencePoints);
            }
            this.increaseMedallionExperience(stack, experiencePoints);
        }
    }

    private void decreasePlayerExperience(Player player, int pointsToRemove) {
        player.giveExperiencePoints(-pointsToRemove);
    }

    private void decreaseMedallionExperience(ItemStack stack, int experience) {
        this.setExperience(stack, this.getExperience(stack) - experience);
    }

    private void increasePlayerExperience(Player player, int xpPoints) {
        player.giveExperiencePoints(xpPoints);
    }

    private void increaseMedallionExperience(ItemStack stack, int xpPoints) {
        this.setExperience(stack, this.getExperience(stack) + xpPoints);
    }

    public int getExperience(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.EXPERIENCE, (Object)0);
    }

    public void setExperience(ItemStack stack, int experience) {
        stack.set(ModDataComponents.EXPERIENCE, (Object)experience);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (player.isShiftKeyDown()) {
            return super.use(level, player, hand);
        }
        this.drainExperience(stack, player, level, this.getDrainXpLevels(stack));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void drainExperience(ItemStack stack, Player player, Level level, int xpLevels) {
        BlockHitResult rayTraceResult = HeroMedallionItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
            BlockPos hitPos = rayTraceResult.getBlockPos().offset(rayTraceResult.getDirection().getNormal());
            this.spawnXpOnGround(stack, level, hitPos, xpLevels);
        } else {
            xpLevels += Math.round(player.experienceProgress);
            while (xpLevels > 0) {
                int xp = Math.max(0, (int)((1.0f - player.experienceProgress) * (float)XpHelper.getExperienceLimitOnLevel(player.experienceLevel)) + 1);
                int pointsToAdd = player.isCreative() ? xp : Math.min(xp, this.getExperience(stack));
                player.giveExperiencePoints(pointsToAdd);
                if (!player.isCreative()) {
                    this.decreaseMedallionExperience(stack, pointsToAdd);
                }
                --xpLevels;
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity.level().isClientSide || this.isEnabled(stack) || !(livingEntity instanceof Player) || this.getUseDuration(stack, livingEntity) - timeLeft > 10) {
            return;
        }
        this.drainExperience(stack, (Player)livingEntity, livingEntity.level(), 1);
    }

    private void spawnXpOnGround(ItemStack stack, Level level, BlockPos hitPos, int xpLevels) {
        int xp;
        if (this.getExperience(stack) >= xp) {
            int j;
            this.decreaseMedallionExperience(stack, xp);
            for (xp = XpHelper.getExperienceForLevel(xpLevels); xp > 0; xp -= j) {
                j = ExperienceOrb.getExperienceValue((int)xp);
                level.addFreshEntity((Entity)new ExperienceOrb(level, (double)hitPos.getX(), (double)hitPos.getY(), (double)hitPos.getZ(), j));
            }
        }
    }

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        List<BlockPos> posInRange = pedestal.getPedestalsInRange(level, (Integer)Config.COMMON.items.heroMedallion.pedestalRange.get());
        for (BlockPos pedestalPos : posInRange) {
            InventoryHelper.runOnInventoryAt(level, pedestalPos, pedestalInventory -> this.repairItemsWithXp(stack, (IItemHandler)pedestalInventory));
        }
        pedestal.setActionCoolDown((Integer)Config.COMMON.items.heroMedallion.repairCoolDown.get());
    }

    private void repairItemsWithXp(ItemStack stack, IItemHandler inventory) {
        for (ItemStack itemToRepair : this.getItemsRepairedWithXp(inventory)) {
            this.repairItemWithXp(stack, itemToRepair);
        }
    }

    private void repairItemWithXp(ItemStack heroMedallion, ItemStack itemToRepair) {
        int xpToRepair = Math.min((Integer)Config.COMMON.items.heroMedallion.repairStepXP.get(), this.getExperience(heroMedallion));
        int durabilityToRepair = Math.min(XpHelper.xpToDurability(xpToRepair), itemToRepair.getDamageValue());
        this.setExperience(heroMedallion, this.getExperience(heroMedallion) - XpHelper.durabilityToXp(durabilityToRepair));
        itemToRepair.setDamageValue(itemToRepair.getDamageValue() - durabilityToRepair);
    }

    private List<ItemStack> getItemsRepairedWithXp(IItemHandler inventory) {
        NonNullList stacksToReturn = NonNullList.create();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!this.canRepairWithXp(stack)) continue;
            stacksToReturn.add((Object)stack);
        }
        return stacksToReturn;
    }

    private boolean canRepairWithXp(ItemStack stack) {
        if (stack.isDamaged() && stack.getDamageValue() > 1) {
            ItemEnchantments itemenchantments = stack.getTagEnchantments();
            for (Holder enchantment : itemenchantments.keySet()) {
                if (!((Enchantment)enchantment.value()).effects().has(EnchantmentEffectComponents.REPAIR_WITH_XP)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        int levelAddition;
        if (player.level().isClientSide) {
            return InteractionResult.PASS;
        }
        int n = levelAddition = scrollDelta > 0.0 ? 1 : -1;
        if (this.isEnabled(stack)) {
            int newLevels = Math.max(0, this.getStopAtXpLevel(stack) + levelAddition);
            this.setStopAtXpLevel(stack, newLevels);
            player.displayClientMessage((Component)Component.translatable((String)"chat.reliquary.hero_medallion.fill_levels", (Object[])new Object[]{Component.literal((String)String.valueOf(newLevels)).withStyle(ChatFormatting.GREEN)}), true);
        } else {
            int newLevels = Math.max(1, this.getDrainXpLevels(stack) + levelAddition);
            this.setDrainXpLevels(stack, newLevels);
            player.displayClientMessage((Component)Component.translatable((String)"chat.reliquary.hero_medallion.drain_levels", (Object[])new Object[]{Component.literal((String)String.valueOf(newLevels)).withStyle(ChatFormatting.RED)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private int getDrainXpLevels(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.DRAIN_XP_LEVELS, (Object)1);
    }

    private int getStopAtXpLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.STOP_AT_XP_LEVEL, (Object)0);
    }

    private void setDrainXpLevels(ItemStack stack, int levels) {
        stack.set(ModDataComponents.DRAIN_XP_LEVELS, (Object)levels);
    }

    private void setStopAtXpLevel(ItemStack stack, int levels) {
        stack.set(ModDataComponents.STOP_AT_XP_LEVEL, (Object)levels);
    }

    @Override
    public ICuriosItem.Type getCuriosType() {
        return ICuriosItem.Type.NECKLACE;
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        this.inventoryTick(stack, player.level(), (Entity)player, 0, false);
    }
}

