/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerDeathHandler;
import reliquary.init.ModItems;
import reliquary.items.ItemBase;
import reliquary.network.SpawnAngelheartVialParticlesPayload;
import reliquary.reference.Config;
import reliquary.util.EntityHelper;
import reliquary.util.InventoryHelper;

public class AngelheartVialItem
extends ItemBase {
    public AngelheartVialItem() {
        super(new Item.Properties());
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(this){

            @Override
            public boolean canApply(Player player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, ModItems.ANGELHEART_VIAL.get());
            }

            @Override
            public boolean apply(Player player, LivingDeathEvent event) {
                AngelheartVialItem.decreaseAngelHeartByOne(player);
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SpawnAngelheartVialParticlesPayload(player.position()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                player.level().playSound(null, player.blockPosition(), SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL, 1.0f, player.level().random.nextFloat() * 0.1f + 0.9f);
                float amountHealed = player.getMaxHealth() * (float)((Integer)Config.COMMON.items.angelHeartVial.healPercentageOfMaxLife.get()).intValue() / 100.0f;
                player.setHealth(amountHealed);
                if (Boolean.TRUE.equals(Config.COMMON.items.angelHeartVial.removeNegativeStatus.get())) {
                    EntityHelper.removeNegativeStatusEffects((LivingEntity)player);
                }
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    private static void decreaseAngelHeartByOne(Player player) {
        ItemStack stack = InventoryHelper.getItemFromAllPlayerHandlers(player, ModItems.ANGELHEART_VIAL.get());
        if (!stack.isEmpty()) {
            stack.shrink(1);
        }
    }
}

