/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.items.AlkahestryTomeItem;

public class AlkahestryChargingRecipe
implements CraftingRecipe {
    private final Ingredient chargingIngredient;
    private final int chargeToAdd;
    private final ItemStack recipeOutput;
    private final Ingredient tomeIngredient;

    public AlkahestryChargingRecipe(Ingredient chargingIngredient, int chargeToAdd) {
        this.chargingIngredient = chargingIngredient;
        this.chargeToAdd = chargeToAdd;
        this.tomeIngredient = new TomeIngredient(chargeToAdd).toVanilla();
        this.recipeOutput = new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get());
        AlkahestryTomeItem.addCharge(this.recipeOutput, chargeToAdd);
        AlkahestryRecipeRegistry.registerChargingRecipe(this);
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack tome = ItemStack.EMPTY;
        int numberOfIngredients = 0;
        for (int x = 0; x < inv.size(); ++x) {
            ItemStack slotStack = inv.getItem(x);
            if (slotStack.isEmpty()) continue;
            boolean inRecipe = false;
            if (this.chargingIngredient.test(slotStack)) {
                inRecipe = true;
                ++numberOfIngredients;
            } else if (tome.isEmpty()) {
                inRecipe = true;
                tome = slotStack;
            }
            if (inRecipe) continue;
            return false;
        }
        return numberOfIngredients > 0 && tome.is((Item)ModItems.ALKAHESTRY_TOME.get()) && AlkahestryTomeItem.getCharge(tome) + this.chargeToAdd * numberOfIngredients <= AlkahestryTomeItem.getChargeLimit();
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        int numberOfIngredients = 0;
        ItemStack tome = ItemStack.EMPTY;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stack = inv.getItem(slot);
            if (this.chargingIngredient.test(stack)) {
                ++numberOfIngredients;
                continue;
            }
            if (stack.getItem() != ModItems.ALKAHESTRY_TOME.get()) continue;
            tome = stack.copy();
        }
        AlkahestryTomeItem.addCharge(tome, this.chargeToAdd * numberOfIngredients);
        return tome;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.chargingIngredient, this.tomeIngredient});
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.recipeOutput;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModItems.ALKAHESTRY_CHARGING_SERIALIZER.get();
    }

    public int getChargeToAdd() {
        return this.chargeToAdd;
    }

    public Ingredient getChargingIngredient() {
        return this.chargingIngredient;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    private static class TomeIngredient
    implements ICustomIngredient {
        private final int chargeToAdd;
        private final ItemStack tome;

        private TomeIngredient(int chargeToAdd) {
            this.chargeToAdd = chargeToAdd;
            this.tome = new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get());
        }

        public boolean test(ItemStack stack) {
            return stack.is((Item)ModItems.ALKAHESTRY_TOME.get()) && AlkahestryTomeItem.getCharge(stack) + this.chargeToAdd <= AlkahestryTomeItem.getChargeLimit();
        }

        public Stream<ItemStack> getItems() {
            return Stream.of(this.tome);
        }

        public boolean isSimple() {
            return false;
        }

        public IngredientType<?> getType() {
            return null;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlkahestryChargingRecipe> {
        private static final MapCodec<AlkahestryChargingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.chargingIngredient), (App)Codec.INT.fieldOf("charge").forGetter(recipe -> recipe.chargeToAdd)).apply((Applicative)instance, AlkahestryChargingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AlkahestryChargingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AlkahestryChargingRecipe::getChargingIngredient, (StreamCodec)ByteBufCodecs.INT, AlkahestryChargingRecipe::getChargeToAdd, AlkahestryChargingRecipe::new);

        public MapCodec<AlkahestryChargingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlkahestryChargingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

