/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.items.ICreativeTabItemGenerator;
import reliquary.items.MobCharmFragmentItem;
import reliquary.items.MobCharmItem;
import reliquary.util.RegistryHelper;

public class ItemDescriptionBuilder {
    private ItemDescriptionBuilder() {
    }

    public static void addIngredientInfo(IRecipeRegistration registration) {
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ALKAHESTRY_TOME.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.MERCY_CROSS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ANGELHEART_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ANGELIC_FEATHER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.APHRODITE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.POTION_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.DESTRUCTION_CATALYST.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.EMPEROR_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ENDER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.FERTILE_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.FORTUNE_COIN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.GLACIAL_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.GLOWING_WATER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.HOLY_HAND_GRENADE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.HANDGUN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.GRIP_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.BARREL_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.HAMMER_ASSEMBLY.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.HARVEST_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.HERO_MEDALLION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ICE_MAGUS_ROD.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.INFERNAL_CHALICE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.INFERNAL_CLAWS.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.INFERNAL_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.KRAKEN_SHELL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.MIDAS_TOUCHSTONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.PHOENIX_DOWN.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.PYROMANCER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.RENDING_GALE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ROD_OF_LYSSA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SOJOURNER_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.TIPPED_ARROW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.VOID_TEAR.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.WITCH_HAT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.WITHERLESS_ROSE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.EMPTY_POTION_VIAL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SPLASH_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.LINGERING_POTION.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.MOB_CHARM_BELT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.ZOMBIE_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SQUID_BEAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.RIB_BONE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.CATALYZING_GLAND.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.CHELICERAE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SLIME_PEARL.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.KRAKEN_SHELL_FRAGMENT.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.BAT_WING.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.WITHERED_RIB.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.MOLTEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.EYE_OF_THE_STORM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.FERTILE_ESSENCE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.FROZEN_CORE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.NEBULOUS_HEART.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.INFERNAL_CLAW.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.GUARDIAN_SPIKE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.CRIMSON_CLOTH.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.LANTERN_OF_PARANOIA.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.MAGICBANE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SALAMANDER_EYE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SERPENT_STAFF.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.SHEARS_OF_WINTER.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.TWILIGHT_CLOAK.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.GLOWING_BREAD.get());
        ItemDescriptionBuilder.registerCharmFragmentItemsDescription(registration);
        ItemDescriptionBuilder.registerCharmItemsDescription(registration);
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.EMPTY_MAGAZINE.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModItems.EMPTY_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.NEUTRAL_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.EXORCISM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.BLAZE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.ENDER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.CONCUSSIVE_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.BUSTER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.SEEKER_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.SAND_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.STORM_MAGAZINE.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.NEUTRAL_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.EXORCISM_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.BLAZE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.ENDER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.CONCUSSIVE_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.BUSTER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.SEEKER_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.SAND_BULLET.get());
        ItemDescriptionBuilder.registerPotionAmmoItemsDescription(registration, ModItems.STORM_BULLET.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModBlocks.ALKAHESTRY_ALTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModBlocks.APOTHECARY_CAULDRON_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModBlocks.APOTHECARY_MORTAR_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModBlocks.INTERDICTION_TORCH_ITEM.get());
        ItemDescriptionBuilder.registerItemDescription(registration, ModBlocks.WRAITH_NODE_ITEM.get());
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((ItemLike)ro.get())).toList(), "pedestal");
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, ModBlocks.PASSIVE_PEDESTAL_ITEMS.values().stream().map(ro -> new ItemStack((ItemLike)ro.get())).toList(), "passive_pedestal");
    }

    private static <I extends Item> void registerItemDescription(IRecipeRegistration registration, I item) {
        NonNullList subItems = NonNullList.create();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        if (!subItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)subItems, new String[0]);
        }
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, Item item, List<ItemStack> items, String ... additionalKeys) {
        String[] langKeys;
        String regName = RegistryHelper.getRegistryName(item).getPath();
        if (additionalKeys.length > 0) {
            langKeys = new String[additionalKeys.length + 1];
            langKeys[0] = regName;
            System.arraycopy(additionalKeys, 0, langKeys, 1, additionalKeys.length);
        } else {
            langKeys = new String[]{regName};
        }
        ItemDescriptionBuilder.addStacksIngredientInfo(registration, items, langKeys);
    }

    private static void addStacksIngredientInfo(IRecipeRegistration registration, List<ItemStack> items, String ... langKeys) {
        registration.addIngredientInfo(items, (IIngredientType)VanillaTypes.ITEM_STACK, ItemDescriptionBuilder.getTranslationKeys(langKeys));
    }

    private static Component[] getTranslationKeys(String ... langKeys) {
        Component[] components = new Component[langKeys.length];
        for (int i = 0; i < langKeys.length; ++i) {
            components[i] = Component.translatable((String)String.format("jei.%s.description.%s", "reliquary", langKeys[i].replace('/', '.')));
        }
        return components;
    }

    private static void registerCharmFragmentItemsDescription(IRecipeRegistration registration) {
        MobCharmFragmentItem item = ModItems.MOB_CHARM_FRAGMENT.get();
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, MobCharmFragmentItem::getEntityRegistryName);
    }

    private static void registerCharmItemsDescription(IRecipeRegistration registration) {
        MobCharmItem item = ModItems.MOB_CHARM.get();
        ItemDescriptionBuilder.registerCharmBasedItems(registration, item, MobCharmItem::getEntityEggRegistryName);
    }

    private static <I extends Item> void registerCharmBasedItems(IRecipeRegistration registration, I item, Function<ItemStack, ResourceLocation> getEntityRegistryName) {
        NonNullList subItems = NonNullList.create();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        for (ItemStack subItem : subItems) {
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(getEntityRegistryName.apply(subItem));
            String path = RegistryHelper.getRegistryName(item).getPath();
            String itemDescriptionKey = String.format("jei.%s.description.%s", "reliquary", path.replace('/', '.'));
            String entityName = entityType.getDescription().getString();
            registration.addIngredientInfo((Object)subItem, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)itemDescriptionKey, (Object[])new Object[]{entityName, entityName})});
        }
    }

    private static <I extends Item> void registerPotionAmmoItemsDescription(IRecipeRegistration registration, I item) {
        NonNullList subItems = NonNullList.create();
        NonNullList potionItems = NonNullList.create();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        for (ItemStack subItem : subItems) {
            if (!subItem.has(DataComponents.POTION_CONTENTS)) continue;
            potionItems.add((Object)subItem);
        }
        if (!potionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)potionItems, "ammo_potion");
        }
        subItems = NonNullList.create();
        NonNullList nonPotionItems = NonNullList.create();
        ((ICreativeTabItemGenerator)item).addCreativeTabItems(arg_0 -> subItems.add(arg_0));
        for (ItemStack subItem : subItems) {
            if (subItem.has(DataComponents.POTION_CONTENTS)) continue;
            nonPotionItems.add((Object)subItem);
        }
        if (!nonPotionItems.isEmpty()) {
            ItemDescriptionBuilder.addStacksIngredientInfo(registration, item, (List<ItemStack>)nonPotionItems, new String[0]);
        }
    }
}

