/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import reliquary.entities.shot.ShotBase;

public class ShotRenderer<T extends ShotBase>
extends EntityRenderer<T> {
    private final Map<EntityType<?>, RenderType> entityCutOuts = new HashMap();

    public ShotRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(0.1f, 0.1f, 0.1f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexBuilder = buffer.getBuffer(this.getEntityCutOut(entity));
        this.addVertex(vertexBuilder, pose, packedLight, -0.5f, -0.25f, 0, 1);
        this.addVertex(vertexBuilder, pose, packedLight, 0.5f, -0.25f, 1, 1);
        this.addVertex(vertexBuilder, pose, packedLight, 0.5f, 0.75f, 1, 0);
        this.addVertex(vertexBuilder, pose, packedLight, -0.5f, 0.75f, 0, 0);
        poseStack.popPose();
        super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void addVertex(VertexConsumer vertexBuilder, PoseStack.Pose pose, int packedLight, float x, float y, int u, int v) {
        vertexBuilder.addVertex(pose, x, y, 0.0f).setColor(255, 255, 255, 255).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private RenderType getEntityCutOut(T entity) {
        if (!this.entityCutOuts.containsKey(entity.getType())) {
            this.entityCutOuts.put(entity.getType(), RenderType.entityCutout((ResourceLocation)((ShotBase)((Object)entity)).getShotTexture()));
        }
        return this.entityCutOuts.get(entity.getType());
    }

    public ResourceLocation getTextureLocation(T entityShot) {
        return ((ShotBase)((Object)entityShot)).getShotTexture();
    }
}

