/*
 * Decompiled with CFR 0.152.
 */
package reliquary.blocks.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import reliquary.blocks.AlkahestryAltarBlock;
import reliquary.blocks.tile.BlockEntityBase;
import reliquary.init.ModBlocks;
import reliquary.reference.Config;
import reliquary.util.WorldHelper;

public class AlkahestryAltarBlockEntity
extends BlockEntityBase {
    private int cycleTime = 0;
    private boolean isActive;
    private int redstoneCount = 0;

    public AlkahestryAltarBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ALKAHESTRY_ALTAR_TILE_TYPE.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos) {
        if (level.isClientSide || !this.isActive || level.isNight() || !level.canSeeSky(pos.above())) {
            return;
        }
        if (this.cycleTime > 0) {
            --this.cycleTime;
        } else {
            this.isActive = false;
            level.setBlockAndUpdate(pos.above(), Blocks.GLOWSTONE.defaultBlockState());
            AlkahestryAltarBlock.updateAltarBlockState(this.isActive(), level, pos);
        }
    }

    public void startCycle(Level level) {
        int defaultCycleTime = (Integer)Config.COMMON.blocks.altar.timeInMinutes.get() * 60 * 20;
        int maximumVariance = (Integer)Config.COMMON.blocks.altar.maximumTimeVarianceInMinutes.get() * 60 * 20;
        this.cycleTime = (int)((double)defaultCycleTime + (double)maximumVariance * level.random.nextGaussian());
        this.redstoneCount = 0;
        this.isActive = true;
    }

    public void stopCycle() {
        this.isActive = false;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.cycleTime = tag.getShort("cycleTime");
        this.redstoneCount = tag.getShort("redstoneCount");
        this.isActive = tag.getBoolean("isActive");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putShort("cycleTime", (short)this.cycleTime);
        tag.putShort("redstoneCount", (short)this.redstoneCount);
        tag.putBoolean("isActive", this.isActive);
    }

    public void addRedstone(Level level, BlockPos pos) {
        ++this.redstoneCount;
        if (this.redstoneCount >= AlkahestryAltarBlockEntity.getRedstoneCost()) {
            AlkahestryAltarBlock.updateAltarBlockState(true, level, pos);
        }
        WorldHelper.notifyBlockUpdate(this);
    }

    private static int getRedstoneCost() {
        return (Integer)Config.COMMON.blocks.altar.redstoneCost.get();
    }

    public int getRedstoneCount() {
        return this.redstoneCount;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getCycleTime() {
        return this.cycleTime;
    }
}

