/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorGlowScreen;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.SavePoseScreen;
import com.mrbysco.armorposer.client.gui.widgets.NumberFieldBox;
import com.mrbysco.armorposer.client.gui.widgets.SizeField;
import com.mrbysco.armorposer.client.gui.widgets.ToggleButton;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.platform.Services;
import com.mrbysco.armorposer.util.ArmorStandData;
import com.mrbysco.armorposer.util.ArmorUtil;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ArmorStandScreen
extends Screen {
    private static final WidgetSprites MIRROR_POSE_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_pose"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_pose_highlighted"));
    private static final WidgetSprites MIRROR_LEGS_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_legs"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_legs_highlighted"));
    private static final WidgetSprites MIRROR_ARMS_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_arms"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_arms_highlighted"));
    private static final WidgetSprites SWAP_TO_HEAD_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/swap_to_head"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/swap_to_head_highlighted"));
    private static final WidgetSprites MIRROR_HANDS_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_hands"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_hands_highlighted"));
    private static final WidgetSprites BLOCK_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/block"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/block_highlighted"));
    private static final WidgetSprites ITEM_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/item"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/item_highlighted"));
    private static final WidgetSprites TOOL_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/tool"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/tool_highlighted"));
    private final ArmorStand entityArmorStand;
    private final ArmorStandData armorStandData;
    private final String[] buttonLabels = new String[]{"invisible", "no_base_plate", "no_gravity", "show_arms", "small", "name_visible", "rotation", "scale"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm", "position"};
    private final String version;
    private NumberFieldBox rotationTextField;
    private final ToggleButton[] toggleButtons = new ToggleButton[6];
    protected final NumberFieldBox[] poseTextFields = new NumberFieldBox[21];
    private SizeField sizeField;
    private LockIconButton lockButton;
    private final boolean allowScrolling;
    private Vec3 lastSendOffset = new Vec3(0.0, 0.0, 0.0);
    private final Tooltip yPositionTooltip = Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.y_position"));
    private final Tooltip yPositionTooltipDisabled = Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.y_position.disabled").withStyle(ChatFormatting.RED));
    private final int whiteColor = 0xFFFFFF;

    public ArmorStandScreen(ArmorStand entityArmorStand) {
        super((Component)Component.translatable((String)"armorposer.gui.title"));
        this.entityArmorStand = entityArmorStand;
        this.armorStandData = new ArmorStandData();
        CompoundTag tag = entityArmorStand.saveWithoutId(new CompoundTag());
        if (!tag.contains("Pose") || tag.getCompound("Pose").isEmpty()) {
            tag.put("Pose", (Tag)ArmorUtil.writeAllPoses(entityArmorStand));
        }
        this.armorStandData.readFromNBT(tag);
        this.allowScrolling = Services.PLATFORM.allowScrolling();
        this.version = Services.PLATFORM.getModVersion();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        int height;
        int width;
        int y;
        int x;
        int i;
        super.init();
        int offsetX = 110;
        int offsetY = 20;
        for (i = 0; i < this.toggleButtons.length; ++i) {
            x = offsetX;
            y = offsetY + i * 22;
            width = 40;
            height = 20;
            this.toggleButtons[i] = new ToggleButton.Builder(this.armorStandData.getBooleanValue(i), button -> {
                ToggleButton toggleButton;
                toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
                this.textFieldUpdated();
            }).bounds(x, y, width, height).build();
            this.addRenderableWidget((GuiEventListener)this.toggleButtons[i]);
            this.toggleButtons[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + this.buttonLabels[i]))));
        }
        this.rotationTextField = new NumberFieldBox(this.font, 1 + offsetX, 1 + offsetY + this.toggleButtons.length * 22, 38, 17, (Component)Component.translatable((String)"armorposer.gui.label.rotation"));
        this.rotationTextField.setValue(String.valueOf((int)this.armorStandData.rotation));
        this.rotationTextField.setMaxLength(4);
        this.addWidget((GuiEventListener)this.rotationTextField);
        this.rotationTextField.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.rotation")));
        this.sizeField = new SizeField(this.font, 1 + offsetX, offsetY + (this.toggleButtons.length + 1) * 22, 38, 17, (Component)Component.translatable((String)"armorposer.gui.label.scale"));
        this.sizeField.setValue(String.valueOf((double)this.entityArmorStand.getScale()));
        this.sizeField.setMaxLength(4);
        this.addWidget((GuiEventListener)this.sizeField);
        this.sizeField.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.scale")));
        if (this.minecraft != null && !Reference.canResize((Player)this.minecraft.player)) {
            this.sizeField.setEditable(false);
            this.sizeField.active = false;
            this.sizeField.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.size.disabled").withStyle(ChatFormatting.RED)));
        }
        offsetX = this.width - 20 - 100;
        for (i = 0; i < this.poseTextFields.length; ++i) {
            boolean lastRow;
            x = 1 + offsetX + i % 3 * 35;
            y = 1 + offsetY + i / 3 * 22;
            width = 28;
            height = 17;
            String value = String.valueOf((int)this.armorStandData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.font, x, y, width, height, (Component)Component.literal((String)value));
            this.poseTextFields[i].setValue(value);
            this.poseTextFields[i].setMaxLength(4);
            boolean bl = lastRow = i >= 18 && i < 21;
            if (lastRow) {
                this.poseTextFields[i].scrollMultiplier = 0.01f;
                this.poseTextFields[i].modValue = 2.1474836E9f;
                this.poseTextFields[i].decimalPoints = 2;
                this.poseTextFields[i].allowDecimal = true;
                this.poseTextFields[i].setMaxLength(6);
            }
            if (i % 3 == 0) {
                this.poseTextFields[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + (lastRow ? "x_position" : "x_rotation")))));
            } else if (i % 3 == 1) {
                this.poseTextFields[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + (lastRow ? "y_position" : "y_rotation")))));
            } else {
                this.poseTextFields[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + (lastRow ? "z_position" : "z_rotation")))));
            }
            this.addWidget((GuiEventListener)this.poseTextFields[i]);
        }
        offsetY = this.height / 4 + 134;
        offsetX = 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.poses"), button -> this.minecraft.setScreen((Screen)new ArmorPosesScreen(this))).bounds(offsetX, offsetY, 130, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.poses"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.copy"), button -> {
            CompoundTag compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.minecraft != null) {
                this.minecraft.keyboardHandler.setClipboard(clipboardData);
            }
        }).bounds(offsetX, offsetY + 22, 42, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.copy"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.minecraft != null) {
                    clipboardData = this.minecraft.keyboardHandler.getClipboard();
                }
                if (clipboardData != null) {
                    CompoundTag compound = TagParser.parseTag(clipboardData);
                    this.readFieldsFromNBT(compound);
                    this.textFieldUpdated();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).bounds(offsetX + 44, offsetY + 22, 42, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.paste"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.save"), button -> this.minecraft.setScreen((Screen)new SavePoseScreen(this))).bounds(offsetX + 88, offsetY + 22, 42, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.save"))).build());
        offsetX = this.width - 20;
        int buttonsLeft = 9;
        int buttonOffset = -4;
        ImageButton mirrorPose = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_POSE_SPRITES, button -> {
            float[] head = new float[]{this.poseTextFields[0].getFloat(), this.poseTextFields[1].getFloat(), this.poseTextFields[2].getFloat()};
            this.poseTextFields[0].setValue(String.valueOf(head[0]));
            this.poseTextFields[1].setValue(String.valueOf(head[1] != 0.0f ? -head[1] : 0.0f));
            this.poseTextFields[2].setValue(String.valueOf(head[2] != 0.0f ? -head[2] : 0.0f));
            float[] body = new float[]{this.poseTextFields[3].getFloat(), this.poseTextFields[4].getFloat(), this.poseTextFields[5].getFloat()};
            this.poseTextFields[3].setValue(String.valueOf(body[0]));
            this.poseTextFields[4].setValue(String.valueOf(body[1] != 0.0f ? -body[1] : 0.0f));
            this.poseTextFields[5].setValue(String.valueOf(body[2] != 0.0f ? -body[2] : 0.0f));
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].setValue(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].setValue(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].setValue(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].setValue(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].setValue(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].setValue(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].setValue(String.valueOf(rightArm[0]));
            this.poseTextFields[13].setValue(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].setValue(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].setValue(String.valueOf(leftArm[0]));
            this.poseTextFields[16].setValue(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].setValue(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorPose.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.mirror")));
        ImageButton mirrorLegs = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_LEGS_SPRITES, button -> {
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].setValue(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].setValue(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].setValue(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].setValue(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].setValue(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].setValue(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorLegs.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.mirror_legs")));
        ImageButton mirrorArms = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_ARMS_SPRITES, button -> {
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].setValue(String.valueOf(rightArm[0]));
            this.poseTextFields[13].setValue(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].setValue(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].setValue(String.valueOf(leftArm[0]));
            this.poseTextFields[16].setValue(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].setValue(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorArms.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.mirror_arms")));
        ImageButton swapToHead = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, SWAP_TO_HEAD_SPRITES, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_WITH_HEAD)));
        swapToHead.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.swap_head")));
        ImageButton swapHands = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_HANDS_SPRITES, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_HANDS)));
        swapHands.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.swap_hands")));
        ImageButton blockButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, BLOCK_SPRITES, button -> {
            try {
                Vec3 pos = this.entityArmorStand.position();
                double xDiff = this.getDesiredOffset(pos.x, 1.0725);
                double yDiff = this.getDesiredOffset(pos.y, -0.655);
                double zDiff = this.getDesiredOffset(pos.z, 0.852);
                Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                switch (closestDegree) {
                    case 90: {
                        double newX = offset.z - 0.7;
                        double newZ = -offset.x + 1.18;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -180: {
                        double newX = -offset.x;
                        double newZ = -offset.z;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -90: {
                        double newX = -offset.z + 0.7;
                        double newZ = offset.x - 1.18;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                }
                CompoundTag tag = TagParser.parseTag((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:0b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-15.0f,135.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                this.readFieldsFromNBT(tag);
                this.toggleButtons[0].setValue(true);
                this.toggleButtons[2].setValue(true);
                this.toggleButtons[3].setValue(true);
                this.rotationTextField.setValue(String.valueOf(closestDegree));
                this.poseTextFields[18].setValue(String.valueOf(offset.x));
                this.poseTextFields[19].setValue(String.valueOf(offset.y));
                this.poseTextFields[20].setValue(String.valueOf(offset.z));
                this.textFieldUpdated();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }));
        blockButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.block")));
        ImageButton itemButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, ITEM_SPRITES, button -> {
            if (ArmorStandScreen.hasShiftDown()) {
                try {
                    Vec3 pos = this.entityArmorStand.position();
                    double xDiff = this.getDesiredOffset(pos.x, 0.86);
                    double yDiff = this.getDesiredOffset(pos.y, -1.41);
                    double zDiff = this.getDesiredOffset(pos.z, -0.0625);
                    Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                    int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                    switch (closestDegree) {
                        case 90: {
                            double newX = offset.z + 1.12;
                            double newZ = -offset.x + 0.74;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -180: {
                            double newX = -offset.x;
                            double newZ = -offset.z;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -90: {
                            double newX = -offset.z - 1.12;
                            double newZ = offset.x - 0.74;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                    }
                    CompoundTag tag = TagParser.parseTag((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:1b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-90.0f,0.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                    this.readFieldsFromNBT(tag);
                    this.toggleButtons[0].setValue(true);
                    this.toggleButtons[2].setValue(true);
                    this.toggleButtons[3].setValue(true);
                    this.rotationTextField.setValue(String.valueOf(closestDegree));
                    this.poseTextFields[18].setValue(String.valueOf(offset.x));
                    this.poseTextFields[19].setValue(String.valueOf(offset.y));
                    this.poseTextFields[20].setValue(String.valueOf(offset.z));
                    this.textFieldUpdated();
                }
                catch (CommandSyntaxException pos) {}
            } else {
                try {
                    Vec3 pos = this.entityArmorStand.position();
                    double xDiff = this.getDesiredOffset(pos.x, 0.886);
                    double yDiff = this.getDesiredOffset(pos.y, -0.78);
                    double zDiff = this.getDesiredOffset(pos.z, 0.205);
                    Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                    int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                    switch (closestDegree) {
                        case 90: {
                            double newX = offset.z + 0.59;
                            double newZ = -offset.x + 0.78;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -180: {
                            double newX = -offset.x;
                            double newZ = -offset.z;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -90: {
                            double newX = -offset.z - 0.59;
                            double newZ = offset.x - 0.78;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                    }
                    CompoundTag tag = TagParser.parseTag((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:1b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[0.0f,0.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                    this.readFieldsFromNBT(tag);
                    this.toggleButtons[0].setValue(true);
                    this.toggleButtons[2].setValue(true);
                    this.toggleButtons[3].setValue(true);
                    this.rotationTextField.setValue(String.valueOf(closestDegree));
                    this.poseTextFields[18].setValue(String.valueOf(offset.x));
                    this.poseTextFields[19].setValue(String.valueOf(offset.y));
                    this.poseTextFields[20].setValue(String.valueOf(offset.z));
                    this.textFieldUpdated();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }));
        itemButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.item").append("\n").append((Component)Component.translatable((String)"armorposer.gui.tooltip.item2").withStyle(ChatFormatting.GRAY))));
        ImageButton toolButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, TOOL_SPRITES, button -> {
            try {
                Vec3 pos = this.entityArmorStand.position();
                double xDiff = this.getDesiredOffset(pos.x, 0.33);
                double yDiff = this.getDesiredOffset(pos.y, -1.285);
                double zDiff = this.getDesiredOffset(pos.z, 0.059999);
                Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                switch (closestDegree) {
                    case 90: {
                        double newX = offset.z + 0.88;
                        double newZ = -offset.x - 0.34;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -180: {
                        double newX = -offset.x;
                        double newZ = -offset.z;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -90: {
                        double newX = -offset.z - 0.88;
                        double newZ = offset.x + 0.34;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                }
                CompoundTag tag = TagParser.parseTag((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:0b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-10.0f,0.0f,-90.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                this.readFieldsFromNBT(tag);
                this.toggleButtons[0].setValue(true);
                this.toggleButtons[2].setValue(true);
                this.toggleButtons[3].setValue(true);
                this.rotationTextField.setValue(String.valueOf(closestDegree));
                this.poseTextFields[18].setValue(String.valueOf(offset.x));
                this.poseTextFields[19].setValue(String.valueOf(offset.y));
                this.poseTextFields[20].setValue(String.valueOf(offset.z));
                this.textFieldUpdated();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }));
        toolButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.tool")));
        this.lockButton = new LockIconButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, button -> {
            this.lockButton.setLocked(!this.lockButton.isLocked());
            this.textFieldUpdated();
        });
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        this.lockButton.setLocked(this.armorStandData.getBooleanValue(6));
        this.lockButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.lock")));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            this.textFieldUpdated();
            this.minecraft.setScreen((Screen)null);
        }).bounds(offsetX - 194, offsetY + 22, 97, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> {
            this.poseTextFields[18].setValue("0");
            this.poseTextFields[19].setValue("0");
            this.poseTextFields[20].setValue("0");
            this.textFieldUpdated();
            this.updateEntity(this.armorStandData.writeToNBT());
            this.minecraft.setScreen((Screen)null);
        }).bounds(offsetX - 95, offsetY + 22, 97, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udca1"), button -> this.minecraft.setScreen((Screen)new ArmorGlowScreen(this))).bounds(0, 0, 16, 16).build());
    }

    private double getDesiredOffset(double posValue, double desiredValue) {
        double value = posValue - (double)((int)posValue);
        if (value < 0.0) {
            value = -value;
        }
        return desiredValue - value;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, 10, 0xFFFFFF, true);
        this.rotationTextField.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.sizeField.render(guiGraphics, mouseX, mouseY, partialTicks);
        int offsetY = 20;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.font);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.drawString(this.font, I18n.get((String)("armorposer.gui.label." + this.buttonLabels[i]), (Object[])new Object[0]), x, y, 0xFFFFFF, true);
        }
        offsetX = this.width - 20 - 100;
        guiGraphics.drawString(this.font, "X", offsetX + 10, 7, 0xFFFFFF, true);
        guiGraphics.drawString(this.font, "Y", offsetX + 45, 7, 0xFFFFFF, true);
        guiGraphics.drawString(this.font, "Z", offsetX + 80, 7, 0xFFFFFF, true);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            String translatedLabel = I18n.get((String)("armorposer.gui.label." + this.sliderLabels[i]), (Object[])new Object[0]);
            int x = offsetX - this.font.width(translatedLabel) - 10;
            Objects.requireNonNull(this.font);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.drawString(this.font, translatedLabel, x, y, 0xFFFFFF, true);
        }
        PoseStack poseStack = guiGraphics.pose();
        if (Services.PLATFORM.allowScrolling()) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"armorposer.gui.label.scroll", (Object[])new Object[]{this.version}), 21, -this.width + 10, 0xAAAAAA, true);
            poseStack.popPose();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void tick() {
        super.tick();
        boolean disabledGravity = this.toggleButtons[2].getValue();
        NumberFieldBox yPositionField = this.poseTextFields[19];
        yPositionField.setEditable(disabledGravity);
        if (disabledGravity) {
            yPositionField.setTooltip(this.yPositionTooltip);
        } else {
            yPositionField.setFocused(false);
            yPositionField.setTooltip(this.yPositionTooltipDisabled);
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        boolean typed = super.charTyped(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        block7: {
            float multiplier;
            block6: {
                float f = multiplier = Screen.hasShiftDown() ? 10.0f : 1.0f;
                if (!this.allowScrolling || !(xScroll > 0.0) && !(yScroll > 0.0)) break block6;
                if (this.rotationTextField.canConsumeInput()) {
                    float nextValue = (this.rotationTextField.getFloat() + multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                    this.rotationTextField.setValue(String.valueOf(nextValue));
                    this.rotationTextField.setCursorPosition(0);
                    this.rotationTextField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                if (this.sizeField.canConsumeInput()) {
                    float nextValue = (float)((double)this.sizeField.getFloat() + (double)(multiplier * this.sizeField.scrollMultiplier));
                    nextValue = Math.clamp(nextValue, this.sizeField.minValue, this.sizeField.maxValue);
                    this.sizeField.setValue(String.valueOf(nextValue));
                    this.sizeField.setCursorPosition(0);
                    this.sizeField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldBox textField : this.poseTextFields) {
                    if (!textField.canConsumeInput()) continue;
                    float nextValue = (textField.getFloat() + multiplier * textField.scrollMultiplier) % textField.modValue;
                    textField.setValue(String.valueOf(nextValue));
                    textField.setCursorPosition(0);
                    textField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                break block7;
            }
            if (!this.allowScrolling || !(xScroll < 0.0) && !(yScroll < 0.0)) break block7;
            if (this.rotationTextField.canConsumeInput()) {
                float previousValue = (this.rotationTextField.getFloat() - multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                this.rotationTextField.setValue(String.valueOf(previousValue));
                this.rotationTextField.setCursorPosition(0);
                this.rotationTextField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
            if (this.sizeField.canConsumeInput()) {
                float previousValue = (float)((double)this.sizeField.getFloat() - (double)(multiplier * this.sizeField.scrollMultiplier));
                previousValue = Math.clamp(previousValue, this.sizeField.minValue, this.sizeField.maxValue);
                this.sizeField.setValue(String.valueOf(previousValue));
                this.sizeField.setCursorPosition(0);
                this.sizeField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.canConsumeInput()) continue;
                float previousValue = (textField.getFloat() - multiplier * textField.scrollMultiplier) % textField.modValue;
                textField.setValue(String.valueOf(previousValue));
                textField.setCursorPosition(0);
                textField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, xScroll, yScroll);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].isFocused()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].moveCursorToEnd(false);
                this.poseTextFields[i].setFocused(false);
                int j = !Screen.hasShiftDown() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].setFocused(true);
                this.poseTextFields[j].moveCursorTo(0, false);
                this.poseTextFields[j].setHighlightPos(this.poseTextFields[j].getValue().length());
            }
        } else {
            if (this.rotationTextField.keyPressed(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.sizeField.keyPressed(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.keyPressed(keyCode, scanCode, modifiers)) continue;
                this.textFieldUpdated();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    protected CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Invisible", this.toggleButtons[0].getValue());
        compound.putBoolean("NoBasePlate", this.toggleButtons[1].getValue());
        compound.putBoolean("NoGravity", this.toggleButtons[2].getValue());
        compound.putBoolean("ShowArms", this.toggleButtons[3].getValue());
        compound.putBoolean("Small", this.toggleButtons[4].getValue());
        compound.putBoolean("CustomNameVisible", this.toggleButtons[5].getValue());
        compound.putBoolean("Invulnerable", this.lockButton.isLocked());
        compound.putInt("DisabledSlots", this.lockButton.isLocked() ? 0x3F3F3F : 0);
        compound.putDouble("Scale", (double)this.sizeField.getFloat());
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.valueOf((float)this.rotationTextField.getFloat()));
        compound.put("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[0].getFloat()));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[1].getFloat()));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[2].getFloat()));
        poseTag.put("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[3].getFloat()));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[4].getFloat()));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[5].getFloat()));
        poseTag.put("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[6].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[7].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[8].getFloat()));
        poseTag.put("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[9].getFloat()));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[10].getFloat()));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[11].getFloat()));
        poseTag.put("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[12].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[13].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[14].getFloat()));
        poseTag.put("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[15].getFloat()));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[16].getFloat()));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.poseTextFields[17].getFloat()));
        poseTag.put("RightArm", (Tag)poseRightArmTag);
        float offsetX = this.poseTextFields[18].getFloat();
        float offsetY = this.poseTextFields[19].getFloat();
        float offsetZ = this.poseTextFields[20].getFloat();
        double offsetXDiff = (double)offsetX - this.lastSendOffset.x;
        double offsetYDiff = (double)offsetY - this.lastSendOffset.y;
        double offsetZDiff = (double)offsetZ - this.lastSendOffset.z;
        ListTag positionOffset = new ListTag();
        positionOffset.add((Object)DoubleTag.valueOf((double)offsetXDiff));
        positionOffset.add((Object)DoubleTag.valueOf((double)offsetYDiff));
        positionOffset.add((Object)DoubleTag.valueOf((double)offsetZDiff));
        compound.put("Move", (Tag)positionOffset);
        this.lastSendOffset = new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
        compound.put("Pose", (Tag)poseTag);
        return compound;
    }

    protected void readFieldsFromNBT(CompoundTag compound) {
        CompoundTag armorStandTag = this.armorStandData.writeToNBT();
        armorStandTag.merge(compound);
        this.armorStandData.readFromNBT(armorStandTag);
        this.toggleButtons[0].setValue(compound.getBoolean("Invisible"));
        this.toggleButtons[1].setValue(compound.getBoolean("NoBasePlate"));
        this.toggleButtons[2].setValue(compound.getBoolean("NoGravity"));
        this.toggleButtons[3].setValue(compound.getBoolean("ShowArms"));
        this.toggleButtons[4].setValue(compound.getBoolean("Small"));
        this.toggleButtons[5].setValue(compound.getBoolean("CustomNameVisible"));
        this.lockButton.setLocked(compound.getBoolean("Invulnerable"));
        this.sizeField.setValue(String.valueOf(compound.getDouble("Scale")));
        ListTag rotationTag = compound.getList("Rotation", 5);
        if (!rotationTag.isEmpty()) {
            this.rotationTextField.setValue(String.valueOf(rotationTag.getFloat(0)));
        }
        CompoundTag poseTag = compound.getCompound("Pose");
        ListTag poseHeadTag = poseTag.getList("Head", 5);
        this.poseTextFields[0].setValue(String.valueOf(poseHeadTag.getFloat(0)));
        this.poseTextFields[1].setValue(String.valueOf(poseHeadTag.getFloat(1)));
        this.poseTextFields[2].setValue(String.valueOf(poseHeadTag.getFloat(2)));
        ListTag poseBodyTag = poseTag.getList("Body", 5);
        this.poseTextFields[3].setValue(String.valueOf(poseBodyTag.getFloat(0)));
        this.poseTextFields[4].setValue(String.valueOf(poseBodyTag.getFloat(1)));
        this.poseTextFields[5].setValue(String.valueOf(poseBodyTag.getFloat(2)));
        ListTag poseLeftLegTag = poseTag.getList("LeftLeg", 5);
        this.poseTextFields[6].setValue(String.valueOf(poseLeftLegTag.getFloat(0)));
        this.poseTextFields[7].setValue(String.valueOf(poseLeftLegTag.getFloat(1)));
        this.poseTextFields[8].setValue(String.valueOf(poseLeftLegTag.getFloat(2)));
        ListTag poseRightLegTag = poseTag.getList("RightLeg", 5);
        this.poseTextFields[9].setValue(String.valueOf(poseRightLegTag.getFloat(0)));
        this.poseTextFields[10].setValue(String.valueOf(poseRightLegTag.getFloat(1)));
        this.poseTextFields[11].setValue(String.valueOf(poseRightLegTag.getFloat(2)));
        ListTag poseLeftArmTag = poseTag.getList("LeftArm", 5);
        this.poseTextFields[12].setValue(String.valueOf(poseLeftArmTag.getFloat(0)));
        this.poseTextFields[13].setValue(String.valueOf(poseLeftArmTag.getFloat(1)));
        this.poseTextFields[14].setValue(String.valueOf(poseLeftArmTag.getFloat(2)));
        ListTag poseRightArmTag = poseTag.getList("RightArm", 5);
        this.poseTextFields[15].setValue(String.valueOf(poseRightArmTag.getFloat(0)));
        this.poseTextFields[16].setValue(String.valueOf(poseRightArmTag.getFloat(1)));
        this.poseTextFields[17].setValue(String.valueOf(poseRightArmTag.getFloat(2)));
        ListTag positionOffset = compound.getList("Move", 6);
        if (!positionOffset.isEmpty()) {
            this.poseTextFields[18].setValue(String.valueOf(positionOffset.getDouble(0) + this.lastSendOffset.x));
            this.poseTextFields[19].setValue(String.valueOf(positionOffset.getDouble(1) + this.lastSendOffset.y));
            this.poseTextFields[20].setValue(String.valueOf(positionOffset.getDouble(2) + this.lastSendOffset.z));
            this.lastSendOffset = new Vec3(positionOffset.getDouble(0) + this.lastSendOffset.x, positionOffset.getDouble(1) + this.lastSendOffset.y, positionOffset.getDouble(2) + this.lastSendOffset.z);
        }
    }

    public static void openScreen(ArmorStand armorStandEntity) {
        Minecraft.getInstance().setScreen((Screen)new ArmorStandScreen(armorStandEntity));
    }

    public void updateEntity(CompoundTag compound) {
        Services.PLATFORM.updateEntity(this.entityArmorStand, compound);
    }
}

