/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.library;

import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.library.EnchLibraryContainer;
import dev.shadowsoffire.placebo.network.VanillaPacketDispatcher;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class EnchLibraryTile
extends BlockEntity {
    protected final Object2IntMap<Holder<Enchantment>> points = new Object2IntOpenHashMap();
    protected final Object2IntMap<Holder<Enchantment>> maxLevels = new Object2IntOpenHashMap();
    protected final Set<EnchLibraryContainer> activeContainers = new HashSet<EnchLibraryContainer>();
    protected final IItemHandler itemHandler = new EnchLibItemHandler();
    protected final int maxLevel;
    protected final int maxPoints;

    public EnchLibraryTile(BlockEntityType<?> type, BlockPos pos, BlockState state, int maxLevel) {
        super(type, pos, state);
        this.maxLevel = maxLevel;
        this.maxPoints = EnchLibraryTile.levelToPoints(maxLevel);
    }

    public void depositBook(ItemStack book) {
        if (book.getItem() != Items.ENCHANTED_BOOK) {
            return;
        }
        ItemEnchantments enchs = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)book);
        for (Object2IntMap.Entry e : enchs.entrySet()) {
            int newPoints = Math.min(this.maxPoints, this.points.getInt(e.getKey()) + EnchLibraryTile.levelToPoints(e.getIntValue()));
            if (newPoints < 0) {
                newPoints = this.maxPoints;
            }
            this.points.put((Object)((Holder)e.getKey()), newPoints);
            this.maxLevels.put((Object)((Holder)e.getKey()), Math.min(this.maxLevel, Math.max(this.maxLevels.getInt(e.getKey()), e.getIntValue())));
        }
        if (enchs.size() > 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
        this.setChanged();
    }

    public void extractEnchant(ItemStack stack, Holder<Enchantment> ench, int level) {
        int curLvl = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).getLevel(ench);
        if (stack.isEmpty() || !this.canExtract(ench, level, curLvl) || level == curLvl) {
            return;
        }
        ItemEnchantments.Mutable enchs = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack));
        enchs.set(ench, level);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchs.toImmutable());
        this.points.put(ench, Math.max(0, this.points.getInt(ench) - EnchLibraryTile.levelToPoints(level) + EnchLibraryTile.levelToPoints(curLvl)));
        if (!this.level.isClientSide()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        }
        this.setChanged();
    }

    public boolean canExtract(Holder<Enchantment> ench, int level, int currentLevel) {
        return this.maxLevels.getInt(ench) >= level && this.points.getInt(ench) >= EnchLibraryTile.levelToPoints(level) - EnchLibraryTile.levelToPoints(currentLevel);
    }

    public static int levelToPoints(int level) {
        return (int)Math.pow(2.0, level - 1);
    }

    public void saveEnchData(CompoundTag tag) {
        CompoundTag points = new CompoundTag();
        for (Object2IntMap.Entry e : this.points.object2IntEntrySet()) {
            points.putInt(((Holder)e.getKey()).getKey().location().toString(), e.getIntValue());
        }
        tag.put("points", (Tag)points);
        CompoundTag levels = new CompoundTag();
        for (Object2IntMap.Entry e : this.maxLevels.object2IntEntrySet()) {
            levels.putInt(((Holder)e.getKey()).getKey().location().toString(), e.getIntValue());
        }
        tag.put("levels", (Tag)levels);
    }

    public void loadEnchData(CompoundTag tag, HolderLookup.RegistryLookup<Enchantment> lookup) {
        CompoundTag points = tag.getCompound("points");
        for (String s : points.getAllKeys()) {
            Optional ench = lookup.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.tryParse((String)s)));
            if (ench.isEmpty()) continue;
            this.points.put((Object)((Holder)ench.get()), points.getInt(s));
        }
        CompoundTag levels = tag.getCompound("levels");
        for (String s : levels.getAllKeys()) {
            Optional ench = lookup.get(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.tryParse((String)s)));
            if (ench.isEmpty()) continue;
            this.maxLevels.put((Object)((Holder)ench.get()), levels.getInt(s));
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        this.saveEnchData(tag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.loadEnchData(tag, (HolderLookup.RegistryLookup<Enchantment>)regs.lookupOrThrow(Registries.ENCHANTMENT));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveEnchData(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        this.loadEnchData(tag, (HolderLookup.RegistryLookup<Enchantment>)registries.lookupOrThrow(Registries.ENCHANTMENT));
        this.activeContainers.forEach(EnchLibraryContainer::onChanged);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public Object2IntMap<Holder<Enchantment>> getPointsMap() {
        return this.points;
    }

    public Object2IntMap<Holder<Enchantment>> getLevelsMap() {
        return this.maxLevels;
    }

    public void addListener(EnchLibraryContainer ctr) {
        this.activeContainers.add(ctr);
    }

    public void removeListener(EnchLibraryContainer ctr) {
        this.activeContainers.remove((Object)ctr);
    }

    public int getMax(Holder<Enchantment> ench) {
        return Math.min(this.maxLevel, this.maxLevels.getInt(ench));
    }

    public IItemHandler getItemHandler(Direction dir) {
        return this.itemHandler;
    }

    private class EnchLibItemHandler
    implements IItemHandler {
        private EnchLibItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.getItem() != Items.ENCHANTED_BOOK || stack.getCount() > 1) {
                return stack;
            }
            if (!simulate) {
                EnchLibraryTile.this.depositBook(stack);
            }
            return ItemStack.EMPTY;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && stack.getItem() == Items.ENCHANTED_BOOK;
        }
    }

    public static class EnderLibraryTile
    extends EnchLibraryTile {
        public EnderLibraryTile(BlockPos pos, BlockState state) {
            super(Ench.Tiles.ENDER_LIBRARY.get(), pos, state, 31);
        }
    }

    public static class BasicLibraryTile
    extends EnchLibraryTile {
        public BasicLibraryTile(BlockPos pos, BlockState state) {
            super(Ench.Tiles.LIBRARY.get(), pos, state, 16);
        }
    }
}

