/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.table.ApothEnchantmentHelper;
import dev.shadowsoffire.apothic_enchanting.util.MiscUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public record BerserkingComponent(List<ConditionalEffect<EnchantmentValueEffect>> hpCost, List<ConditionalEffect<VariableMobEffect>> mobEffects, List<ConditionalEffect<EnchantmentValueEffect>> cooldown) {
    public static final Codec<BerserkingComponent> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf().fieldOf("hp_cost").forGetter(BerserkingComponent::hpCost), (App)ConditionalEffect.codec(VariableMobEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf().fieldOf("mob_effects").forGetter(BerserkingComponent::mobEffects), (App)ConditionalEffect.codec((Codec)EnchantmentValueEffect.CODEC, (LootContextParamSet)LootContextParamSets.ENCHANTED_DAMAGE).listOf().fieldOf("cooldown").forGetter(BerserkingComponent::cooldown)).apply((Applicative)inst, BerserkingComponent::new));

    public static void attemptToGoBerserk(LivingDamageEvent.Post e) {
        Pair<BerserkingComponent, Integer> data;
        LivingEntity target = e.getEntity();
        ResourceLocation key = BuiltInRegistries.ENCHANTMENT_EFFECT_COMPONENT_TYPE.getKey(Ench.EnchantEffects.BERSERKING);
        if (e.getSource().getEntity() != null && !MiscUtil.isOnCooldown(key, target) && (data = ApothEnchantmentHelper.getHighestEquippedLevel(Ench.EnchantEffects.BERSERKING, target)) != null) {
            BerserkingComponent comp = (BerserkingComponent)data.getFirst();
            int level = (Integer)data.getSecond();
            LootContext ctx = Enchantment.damageContext((ServerLevel)((ServerLevel)target.level()), (int)level, (Entity)target, (DamageSource)e.getSource());
            float hpCost = ApothEnchantmentHelper.processValue(comp.hpCost, ctx, level, 0.0f);
            target.invulnerableTime = 0;
            target.hurt(target.damageSources().source(Ench.DamageTypes.CORRUPTED), hpCost);
            Enchantment.applyEffects(comp.mobEffects, (LootContext)ctx, variableEffect -> target.addEffect(variableEffect.createEffectInstance(level, ctx.getRandom())));
            MiscUtil.startCooldown(key, target, (int)ApothEnchantmentHelper.processValue(comp.cooldown(), ctx, level, 0.0f));
        }
    }

    public record VariableMobEffect(Holder<MobEffect> effect, List<EnchantmentValueEffect> duration, List<EnchantmentValueEffect> amplifier, boolean ambient, boolean visible, Optional<Boolean> showIcon) {
        public static final Codec<VariableMobEffect> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("mob_effect").forGetter(VariableMobEffect::effect), (App)EnchantmentValueEffect.CODEC.listOf().fieldOf("duration").forGetter(VariableMobEffect::duration), (App)EnchantmentValueEffect.CODEC.listOf().fieldOf("amplifier").forGetter(VariableMobEffect::amplifier), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(VariableMobEffect::ambient), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(VariableMobEffect::visible), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(VariableMobEffect::showIcon)).apply((Applicative)inst, VariableMobEffect::new));

        public MobEffectInstance createEffectInstance(int level, RandomSource rand) {
            int duration = (int)ApothEnchantmentHelper.processValue(this.duration, rand, level, 0.0f);
            int amplifier = (int)ApothEnchantmentHelper.processValue(this.amplifier, rand, level, 0.0f);
            return new MobEffectInstance(this.effect, duration, amplifier, this.ambient, this.visible, this.showIcon.orElse(this.visible).booleanValue());
        }
    }
}

