/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_spawners.stats;

import com.mojang.serialization.Codec;
import dev.shadowsoffire.apothic_spawners.block.ApothSpawnerTile;
import dev.shadowsoffire.apothic_spawners.stats.CustomStat;
import dev.shadowsoffire.apothic_spawners.stats.SpawnerStat;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class PercentageStat
extends CustomStat<Float> {
    public PercentageStat(Float defaultValue) {
        super(defaultValue);
    }

    @Override
    public Codec<Float> getValueCodec() {
        return Codec.floatRange((float)-1.0f, (float)1.0f);
    }

    @Override
    public Component getTooltipImpl(ApothSpawnerTile spawner) {
        return SpawnerStat.createTooltip(this, this.formatValue((Float)this.getValue(spawner)));
    }

    @Override
    public boolean applyModifier(ApothSpawnerTile spawner, Float value, Optional<Float> min, Optional<Float> max) {
        Float old = (Float)this.getValue(spawner);
        this.setValue(spawner, this.clamp(Float.valueOf(old.floatValue() + value.floatValue()), min, max));
        return old != this.getValue(spawner);
    }

    @Override
    public String formatValue(Float value) {
        return ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value.floatValue() * 100.0f) + "%";
    }

    private Float clamp(Float value, Optional<Float> min, Optional<Float> max) {
        if (min.isPresent()) {
            value = Float.valueOf(Math.max(value.floatValue(), min.get().floatValue()));
        }
        if (max.isPresent()) {
            value = Float.valueOf(Math.min(value.floatValue(), max.get().floatValue()));
        }
        return value;
    }
}

