/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class ParticleGraveSoul
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final double radius;
    private final double centerX;
    private final double centerZ;

    private ParticleGraveSoul(SpriteSet spriteSet, ClientLevel level, double x, double y, double z, double radius) {
        super(level, x, y + 0.85, z);
        this.lifetime = 100;
        this.quadSize = 0.03f;
        this.centerX = x + 0.5;
        this.centerZ = z + 0.5;
        this.radius = radius;
        this.updatePosition();
        this.setAlpha(0.7f);
        this.setColor(0.31764707f, 0.09803922f, 0.54509807f);
        this.hasPhysics = false;
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(this.spriteSet);
    }

    private void updatePosition() {
        double ratio = (double)this.age / (double)this.lifetime;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.xo = this.x = this.centerX + this.radius * Math.cos(Math.PI * 2 * ratio);
        this.yo = this.y;
        this.zo = this.z = this.centerZ + this.radius * Math.sin(Math.PI * 2 * ratio);
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.setSpriteFromAge(this.spriteSet);
            this.updatePosition();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double motionX, double motionY, double motionZ) {
            return new ParticleGraveSoul(this.spriteSet, level, x, y, z, 0.3);
        }
    }
}

