/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.ConfigTomb;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;

public class WorldHelper {
    public static float getRandom(RandomSource rand, double min, double max) {
        return (float)(rand.nextDouble() * (max - min) + min);
    }

    public static boolean isValidPlacement(Level level, BlockPos myPos) {
        if (level.isOutsideBuildHeight(myPos)) {
            return false;
        }
        BlockState blockState = level.getBlockState(myPos);
        return blockState.isAir() || blockState.getBlock() == Blocks.WATER;
    }

    public static GlobalPos findGraveSpawn(Player player, BlockPos initPos) {
        int xRange = (Integer)ConfigTomb.HSEARCHRANGE.get();
        int yRange = (Integer)ConfigTomb.VSEARCHRANGE.get();
        int zRange = (Integer)ConfigTomb.HSEARCHRANGE.get();
        Level level = player.level();
        if (WorldHelper.isValidPlacement(level, initPos) && WorldHelper.isValidSolid(level, initPos)) {
            return new GlobalPos(level.dimension(), initPos);
        }
        ArrayList<BlockPos> positionsWithSolidBelow = new ArrayList<BlockPos>();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int x = initPos.getX() - xRange; x < initPos.getX() + xRange; ++x) {
            for (int y = initPos.getY() - yRange; y < initPos.getY() + yRange; ++y) {
                for (int z = initPos.getZ() - zRange; z < initPos.getZ() + zRange; ++z) {
                    BlockPos myPos = new BlockPos(x, y, z);
                    boolean isValid = WorldHelper.isValidPlacement(level, myPos);
                    if (!isValid) continue;
                    if (WorldHelper.isValidSolid(level, myPos)) {
                        positionsWithSolidBelow.add(myPos);
                        continue;
                    }
                    positions.add(myPos);
                }
            }
        }
        BlockPos found = null;
        if (positionsWithSolidBelow.size() > 0) {
            WorldHelper.sortByDistance(initPos, positionsWithSolidBelow);
            found = (BlockPos)positionsWithSolidBelow.getFirst();
        } else if (positions.size() > 0) {
            WorldHelper.sortByDistance(initPos, positions);
            found = (BlockPos)positions.getFirst();
        } else {
            return null;
        }
        return new GlobalPos(level.dimension(), found);
    }

    private static void sortByDistance(BlockPos initPos, List<BlockPos> positions) {
        positions.sort((pos0, pos1) -> {
            double dist0 = Math.sqrt(pos0.distSqr((Vec3i)initPos));
            double dist1 = Math.sqrt(pos1.distSqr((Vec3i)initPos));
            return Double.compare(dist0, dist1);
        });
    }

    private static boolean isValidSolid(Level level, BlockPos myPos) {
        return level.getBlockState(myPos.below()).canOcclude();
    }

    public static BlockPos getInitialPos(Level level, BlockPos pos) {
        boolean validY;
        WorldBorder border = level.getWorldBorder();
        boolean validXZ = border.isWithinBounds(pos);
        boolean bl = validY = !level.isOutsideBuildHeight(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (!validXZ) {
            x = Math.min(Math.max(pos.getX(), (int)border.getMinX()), (int)border.getMaxX());
            z = Math.min(Math.max(pos.getZ(), (int)border.getMinZ()), (int)border.getMaxZ());
        }
        if (!validY) {
            if (y < 1) {
                y = 1;
            }
            if (y > level.getMaxBuildHeight()) {
                y = level.getMaxBuildHeight() - 1;
            }
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isRuleKeepInventory(Player player) {
        return WorldHelper.isRuleKeepInventory(player.level());
    }

    public static boolean isRuleKeepInventory(Level level) {
        return level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
    }

    public static void removeNoEvent(Level level, BlockPos pos) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
    }

    public static boolean placeGrave(Level level, BlockPos pos, BlockState state) {
        return level.setBlock(pos, state, 2);
    }

    public static boolean isNight(Level level) {
        float angle = level.getSunAngle(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static float[] getRGBColor3F(int color) {
        return new float[]{(float)FastColor.ABGR32.red((int)color) / 255.0f, (float)FastColor.ABGR32.green((int)color) / 255.0f, (float)FastColor.ABGR32.blue((int)color) / 255.0f};
    }

    public static Component getDimensionName(ResourceKey<Level> levelResourceKey) {
        ResourceLocation dimLocation = levelResourceKey.location();
        return Component.translatableWithFallback((String)dimLocation.toLanguageKey("dimension"), (String)dimLocation.toString());
    }
}

