/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.helper;

import com.lothrazar.simpletomb.helper.CuriosHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class EntityHelper {
    public static final String NBT_PLAYER_PERSISTED = "PlayerPersisted";

    public static boolean autoEquip(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (registryName == null) {
            return false;
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Holder)player.level().holderOrThrow(Enchantments.BINDING_CURSE), (ItemStack)stack) > 0) {
            return false;
        }
        if (stack.getMaxStackSize() == 1) {
            if (ModList.get().isLoaded("curios") && CuriosHelper.autoEquip(stack, player)) {
                return true;
            }
            if (player.getOffhandItem().isEmpty() && stack.getItem().canPerformAction(stack, ItemAbilities.SHIELD_BLOCK)) {
                player.setItemSlot(EquipmentSlot.OFFHAND, stack.copy());
                return true;
            }
            EquipmentSlot slot = stack.getItem().getEquipmentSlot(stack);
            boolean isElytra = false;
            if (slot == null) {
                if (stack.getItem() instanceof ArmorItem) {
                    slot = ((ArmorItem)stack.getItem()).getEquipmentSlot();
                } else {
                    if (!(stack.getItem() instanceof ElytraItem)) {
                        return false;
                    }
                    slot = EquipmentSlot.CHEST;
                    isElytra = true;
                }
            } else if (slot == EquipmentSlot.CHEST) {
                isElytra = stack.getItem() instanceof ElytraItem;
            }
            int slotId = slot.getIndex();
            ItemStack stackInSlot = (ItemStack)player.getInventory().armor.get(slotId);
            if (stackInSlot.isEmpty()) {
                player.getInventory().armor.set(slotId, (Object)stack.copy());
                return true;
            }
            if (slot != EquipmentSlot.CHEST) {
                return false;
            }
            if (isElytra) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.copy());
                player.getInventory().armor.set(slotId, (Object)stack.copy());
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof Player && !(entity instanceof FakePlayer);
    }

    public static boolean isValidPlayerMP(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.level().isClientSide;
    }

    public static CompoundTag getPersistentTag(Player player) {
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.contains(NBT_PLAYER_PERSISTED)) {
            CompoundTag persistentTag = (CompoundTag)persistentData.get(NBT_PLAYER_PERSISTED);
            return persistentTag;
        }
        CompoundTag persistentTag = new CompoundTag();
        persistentData.put(NBT_PLAYER_PERSISTED, (Tag)persistentTag);
        return persistentTag;
    }
}

