/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;

public class RotationUtil {
    public static final Direction BASE_DIRECTION = Direction.SOUTH;

    public static Rotation getTransformRotation(Direction orientation) {
        return RotationUtil.getHorizontalDifferenceRotation(orientation, BASE_DIRECTION);
    }

    public static Rotation getUntransformRotation(Direction orientation) {
        return RotationUtil.getHorizontalDifferenceRotation(BASE_DIRECTION, orientation);
    }

    public static Rotation getHorizontalDifferenceRotation(Direction from, Direction to) {
        int indexDifference = to.get2DDataValue() - from.get2DDataValue();
        if (indexDifference < 0) {
            indexDifference += 4;
        }
        return Rotation.values()[indexDifference % 4];
    }

    public static BlockPos transformBlockPos(Rotation rotation, BlockPos pos, BlockPos origin) {
        BlockPos offset = pos.subtract((Vec3i)origin);
        return offset.rotate(rotation);
    }

    public static BlockPos untransformBlockPos(Rotation unrotation, BlockPos offset, BlockPos origin) {
        BlockPos unRotatedOffset = offset.rotate(unrotation);
        return origin.offset((Vec3i)unRotatedOffset);
    }
}

