/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import commoble.bagofyurting.BagOfYurtingItem;
import commoble.bagofyurting.BagOfYurtingMod;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessBagUpgradeRecipe
extends ShapelessRecipe {
    public static final MapCodec<ShapelessBagUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("result").forGetter(ShapelessBagUpgradeRecipe::upgradeResult), (App)NonNullList.codecOf((Codec)Ingredient.CODEC).fieldOf("ingredients").forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)builder, ShapelessBagUpgradeRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessBagUpgradeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ShapelessBagUpgradeRecipe::upgradeResult, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), ShapelessRecipe::getIngredients, ShapelessBagUpgradeRecipe::new);
    private final ItemStack upgradeResult;
    private final int displayRadius;

    public ItemStack upgradeResult() {
        return this.upgradeResult;
    }

    public int displayRadius() {
        return this.displayRadius;
    }

    public ShapelessBagUpgradeRecipe(ItemStack upgradeResult, NonNullList<Ingredient> ingredients) {
        this(upgradeResult, ingredients, 1);
    }

    public ShapelessBagUpgradeRecipe(ItemStack upgradeResult, NonNullList<Ingredient> ingredients, int displayRadius) {
        super("", CraftingBookCategory.MISC, upgradeResult, ingredients);
        this.displayRadius = displayRadius;
        this.upgradeResult = upgradeResult;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BagOfYurtingMod.get().shapelessUpgradeRecipeSerializer.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return BagOfYurtingItem.withRadius(super.getResultItem(registries), this.displayRadius);
    }

    public ItemStack assemble(CraftingInput craftingSlots, HolderLookup.Provider registries) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int slotCount = craftingSlots.ingredientCount();
        for (int i = 0; i < slotCount; ++i) {
            stacks.add(craftingSlots.getItem(i));
        }
        return BagOfYurtingItem.getUpgradeRecipeResult(stacks, this.getResultItem(registries));
    }

    public boolean isSpecial() {
        return true;
    }
}

