/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import com.mojang.serialization.Codec;
import commoble.bagofyurting.BagOfYurtingItem;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import commoble.bagofyurting.IsWasSprintPacket;
import commoble.bagofyurting.OptionalSpawnParticlesPacket;
import commoble.bagofyurting.ServerConfig;
import commoble.bagofyurting.ShapelessBagUpgradeRecipe;
import commoble.bagofyurting.client.ClientProxy;
import commoble.bagofyurting.util.ConfigHelper;
import commoble.bagofyurting.util.SimpleRecipeSerializer;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="bagofyurting")
public class BagOfYurtingMod {
    public static final String MODID = "bagofyurting";
    public static final ResourceLocation UPGRADE_RECIPE_ID = ResourceLocation.fromNamespaceAndPath((String)"bagofyurting", (String)"bag_of_yurting_upgrade");
    private static BagOfYurtingMod instance;
    private final ServerConfig serverConfig;
    public final DeferredHolder<Item, BagOfYurtingItem> bagOfYurtingItem;
    public final DeferredHolder<RecipeSerializer<?>, SimpleRecipeSerializer<ShapelessBagUpgradeRecipe>> shapelessUpgradeRecipeSerializer;
    public final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> radiusComponent;
    public final DeferredHolder<DataComponentType<?>, DataComponentType<CompressedBagOfYurtingData>> yurtDataComponent;

    public static BagOfYurtingMod get() {
        return instance;
    }

    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    public BagOfYurtingMod(IEventBus modBus) {
        instance = this;
        this.serverConfig = ConfigHelper.register(MODID, ModConfig.Type.SERVER, ServerConfig::create);
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        DeferredRegister items = BagOfYurtingMod.makeDeferredRegister(modBus, Registries.ITEM);
        DeferredRegister recipeSerializers = BagOfYurtingMod.makeDeferredRegister(modBus, Registries.RECIPE_SERIALIZER);
        DeferredRegister dataComponents = BagOfYurtingMod.makeDeferredRegister(modBus, Registries.DATA_COMPONENT_TYPE);
        this.bagOfYurtingItem = items.register("bag_of_yurting", () -> new BagOfYurtingItem(new Item.Properties().stacksTo(1)));
        this.shapelessUpgradeRecipeSerializer = recipeSerializers.register("shapeless_bag_of_yurting_upgrade", () -> new SimpleRecipeSerializer<ShapelessBagUpgradeRecipe>(ShapelessBagUpgradeRecipe.CODEC, ShapelessBagUpgradeRecipe.STREAM_CODEC));
        this.radiusComponent = dataComponents.register("radius", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT).build());
        this.yurtDataComponent = dataComponents.register("yurtdata", () -> DataComponentType.builder().persistent(CompressedBagOfYurtingData.CODEC).cacheEncoding().build());
        modBus.addListener(this::onBuildCreativeTabs);
        modBus.addListener(this::onRegisterPayloadHandlers);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.subscribeClientEvents(modBus, forgeBus);
        }
    }

    private static <T> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, ResourceKey<Registry<T>> registryKey) {
        DeferredRegister register = DeferredRegister.create(registryKey, (String)MODID);
        register.register(modBus);
        return register;
    }

    void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            BagOfYurtingItem item = (BagOfYurtingItem)((Object)this.bagOfYurtingItem.get());
            ItemStack baseStack = new ItemStack((ItemLike)item);
            for (int i = 0; i < 7; ++i) {
                event.accept(BagOfYurtingItem.withRadius(baseStack, i));
            }
        }
    }

    void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        event.registrar("0").playToServer(IsWasSprintPacket.TYPE, IsWasSprintPacket.STREAM_CODEC, IsWasSprintPacket::handle).playToClient(OptionalSpawnParticlesPacket.TYPE, OptionalSpawnParticlesPacket.STREAM_CODEC, OptionalSpawnParticlesPacket::handle);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static final class Tags {
        private Tags() {
        }

        public static final class Blocks {
            public static final TagKey<Block> WHITELIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BagOfYurtingMod.id("whitelist"));
            public static final TagKey<Block> BLACKLIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BagOfYurtingMod.id("blacklist"));
            public static final TagKey<Block> REPLACEABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BagOfYurtingMod.id("replaceable"));

            private Blocks() {
            }
        }
    }
}

