/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.strategy;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.glodblock.github.appflux.api.ItemContext;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.strategy.context.CarriedContext;
import com.glodblock.github.appflux.common.me.strategy.context.PlayerInvContext;
import com.glodblock.github.appflux.util.AFUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class FEContainerItemStrategy
implements ContainerItemStrategy<FluxKey, ItemContext> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)AFUtil.findCapability(stack, Capabilities.EnergyStorage.ITEM);
        if (energy != null && energy.getEnergyStored() > 0) {
            return new GenericStack((AEKey)FluxKey.of(EnergyType.FE), (long)energy.getEnergyStored());
        }
        return null;
    }

    @Nullable
    public ItemContext findCarriedContext(Player player, AbstractContainerMenu menu) {
        if (menu.getCarried().getCapability(Capabilities.EnergyStorage.ITEM) != null) {
            return new CarriedContext(player, menu);
        }
        return null;
    }

    @Nullable
    public ItemContext findPlayerSlotContext(Player player, int slot) {
        if (player.getInventory().getItem(slot).getCapability(Capabilities.EnergyStorage.ITEM) != null) {
            return new PlayerInvContext(player, slot);
        }
        return null;
    }

    public long extract(ItemContext context, FluxKey what, long amount, Actionable mode) {
        ItemStack stack = context.getStack();
        ItemStack copy = stack.copyWithCount(1);
        IEnergyStorage handler = (IEnergyStorage)AFUtil.findCapability(copy, Capabilities.EnergyStorage.ITEM);
        if (handler == null) {
            return 0L;
        }
        int extracted = handler.extractEnergy(AFUtil.clampLong(amount), mode.isSimulate());
        if (mode == Actionable.MODULATE) {
            stack.shrink(1);
            context.addOverflow(copy);
        }
        return extracted;
    }

    public long insert(ItemContext context, FluxKey what, long amount, Actionable mode) {
        ItemStack stack = context.getStack();
        ItemStack copy = stack.copyWithCount(1);
        IEnergyStorage handler = (IEnergyStorage)AFUtil.findCapability(copy, Capabilities.EnergyStorage.ITEM);
        if (handler == null) {
            return 0L;
        }
        int filled = handler.receiveEnergy(AFUtil.clampLong(amount), mode.isSimulate());
        if (mode == Actionable.MODULATE) {
            stack.shrink(1);
            context.addOverflow(copy);
        }
        return filled;
    }

    public void playFillSound(Player player, FluxKey what) {
    }

    public void playEmptySound(Player player, FluxKey what) {
    }

    @Nullable
    public GenericStack getExtractableContent(ItemContext context) {
        return this.getContainedStack(context.getStack());
    }
}

