/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.rightclick;

import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.api.rightclick.RightClickHandler;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.client.PlatformUtil;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public enum ShovelFlattening implements RightClickHandler
{
    INSTANCE;


    @Override
    public int handleRightClickBlock(ShapeContext shapeContext, InteractionHand hand, Collection<BlockPos> positions) {
        ServerPlayer player = shapeContext.player();
        if (!((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_SHOVEL.get()).booleanValue() || !PlatformUtil.canFlattenPath(player.getMainHandItem())) {
            return 0;
        }
        int didWork = 0;
        for (BlockPos pos : positions) {
            if (!player.level().getBlockState(pos.above()).isAir()) continue;
            BlockState state = player.level().getBlockState(pos);
            BlockState newState = ShovelItemAccess.getFlattenables().get(state.getBlock());
            if (newState == null && state.is(FTBUltimine.FLATTENABLE_TAG)) {
                newState = Blocks.DIRT_PATH.defaultBlockState();
            }
            if (newState == null) continue;
            player.level().setBlock(pos, newState, 11);
            ++didWork;
            boolean result = this.hurtItemAndCheckIfBroken(player, hand);
            player.level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            if (!result && player.getFoodData().getFoodLevel() > 0) continue;
            break;
        }
        if (didWork > 0) {
            player.level().playSound((Player)player, shapeContext.pos(), SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return didWork;
    }
}

