/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftbultimine.BlockBreakingRegistry;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimineCommands;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.RestrictionHandlerRegistry;
import dev.ftb.mods.ftbultimine.api.FTBUltimineAPI;
import dev.ftb.mods.ftbultimine.api.blockbreaking.BlockBreakHandler;
import dev.ftb.mods.ftbultimine.api.blockbreaking.RegisterBlockBreakHandlerEvent;
import dev.ftb.mods.ftbultimine.api.crop.RegisterCropLikeEvent;
import dev.ftb.mods.ftbultimine.api.restriction.RegisterRestrictionHandlerEvent;
import dev.ftb.mods.ftbultimine.api.rightclick.RegisterRightClickHandlerEvent;
import dev.ftb.mods.ftbultimine.api.shape.RegisterShapeEvent;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.api.util.ItemCollector;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.crops.VanillaCropLikeHandler;
import dev.ftb.mods.ftbultimine.integration.IntegrationHandler;
import dev.ftb.mods.ftbultimine.integration.acceldecay.AcceleratedDecay;
import dev.ftb.mods.ftbultimine.integration.acceldecay.LogBreakTracker;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import dev.ftb.mods.ftbultimine.rightclick.AxeStripping;
import dev.ftb.mods.ftbultimine.rightclick.CropHarvesting;
import dev.ftb.mods.ftbultimine.rightclick.FarmlandConversion;
import dev.ftb.mods.ftbultimine.rightclick.RightClickDispatcher;
import dev.ftb.mods.ftbultimine.rightclick.ShovelFlattening;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.LargeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollector tempBlockDropsList;
    public static final TagKey<Item> DENY_TAG;
    public static final TagKey<Item> STRICT_DENY_TAG;
    public static final TagKey<Item> ALLOW_TAG;
    public static final TagKey<Block> EXCLUDED_BLOCKS;
    public static final TagKey<Block> BLOCK_WHITELIST;
    public static final TagKey<Block> TILLABLE_TAG;
    public static final TagKey<Block> FLATTENABLE_TAG;
    private static Predicate<Player> permissionOverride;

    public static void setPermissionOverride(Predicate<Player> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        ConfigManager.getInstance().registerClientConfig(FTBUltimineClientConfig.CONFIG, "ftbultimine.client_settings");
        ConfigManager.getInstance().registerServerConfig(FTBUltimineServerConfig.CONFIG, "ftbultimine.server_settings", true, FTBUltimineServerConfig::onConfigChanged);
        FTBUltimineNet.init();
        IntegrationHandler.init();
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new DataReloadListener());
        LifecycleEvent.SETUP.register(this::commonSetup);
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        LifecycleEvent.SERVER_STOPPING.register(this::serverStopping);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
        CommandRegistrationEvent.EVENT.register(FTBUltimineCommands::registerCommands);
        RegisterRightClickHandlerEvent.REGISTER.register(this::registerBuiltinHandlers);
        RegisterShapeEvent.REGISTER.register(this::registerBuiltinShapes);
        RegisterCropLikeEvent.REGISTER.register(this::registerCropHandlers);
    }

    private void commonSetup() {
        ((RegisterRestrictionHandlerEvent)RegisterRestrictionHandlerEvent.REGISTER.invoker()).register(RestrictionHandlerRegistry.INSTANCE);
        ((RegisterShapeEvent)RegisterShapeEvent.REGISTER.invoker()).register(ShapeRegistry.INSTANCE);
    }

    private void registerBuiltinShapes(RegisterShapeEvent.Registry shapeRegistry) {
        shapeRegistry.register(new ShapelessShape());
        shapeRegistry.register(new SmallTunnelShape());
        shapeRegistry.register(new SmallSquareShape());
        shapeRegistry.register(new LargeTunnelShape());
        shapeRegistry.register(new MiningTunnelShape());
        shapeRegistry.register(new EscapeTunnelShape());
    }

    private void registerCropHandlers(RegisterCropLikeEvent.Dispatcher dispatcher) {
        dispatcher.registerHandler(VanillaCropLikeHandler.INSTANCE);
    }

    private void registerBuiltinHandlers(RegisterRightClickHandlerEvent.Dispatcher dispatcher) {
        dispatcher.registerHandler(AxeStripping.INSTANCE);
        dispatcher.registerHandler(ShovelFlattening.INSTANCE);
        dispatcher.registerHandler(FarmlandConversion.INSTANCE);
        dispatcher.registerHandler(CropHarvesting.INSTANCE);
    }

    @NotNull
    public FTBUltiminePlayerData getOrCreatePlayerData(Player player) {
        return this.cachedDataMap.computeIfAbsent(player.getUUID(), FTBUltiminePlayerData::new);
    }

    private void playerJoined(ServerPlayer serverPlayer) {
        NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(serverPlayer), SyncUltimineTimePacket.TimeType.COOLDOWN));
    }

    private void serverStarting(MinecraftServer server) {
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        ((RegisterRightClickHandlerEvent)RegisterRightClickHandlerEvent.REGISTER.invoker()).register(RightClickDispatcher.getInstance());
        ((RegisterCropLikeEvent)RegisterCropLikeEvent.REGISTER.invoker()).register(CropLikeRegistry.getInstance());
        ((RegisterBlockBreakHandlerEvent)RegisterBlockBreakHandlerEvent.REGISTER.invoker()).register(BlockBreakingRegistry.getInstance());
    }

    private void serverStopping(MinecraftServer server) {
        RightClickDispatcher.getInstance().clear();
        CropLikeRegistry.getInstance().clear();
        BlockBreakingRegistry.getInstance().clear();
    }

    public void setKeyPressed(ServerPlayer player, boolean pressed) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((Player)player);
        data.setPressed(pressed);
        data.clearCache();
        if (!data.isPressed()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SendShapePacket.adjustShapeOnly(data.getCurrentShapeIndex()));
        }
    }

    public void modeChanged(ServerPlayer player, boolean next) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((Player)player);
        data.cycleShape(next);
        data.clearCache();
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SendShapePacket.adjustShapeOnly(data.getCurrentShapeIndex()));
    }

    public static boolean isValidTool(ItemStack mainHand, ItemStack offHand) {
        if (mainHand.is(STRICT_DENY_TAG) || offHand.is(STRICT_DENY_TAG) || mainHand.is(DENY_TAG)) {
            return false;
        }
        if (((Boolean)FTBUltimineServerConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand.isEmpty()) {
                return false;
            }
            return mainHand.getItem() instanceof TieredItem || mainHand.getMaxDamage() > 0 || mainHand.is(ALLOW_TAG);
        }
        return true;
    }

    public boolean canUltimine(Player player) {
        ItemStack offHand;
        if (PlayerHooks.isFake((Player)player) || player.getUUID() == null || CooldownTracker.isOnCooldown(player)) {
            return false;
        }
        if (player.getFoodData().getFoodLevel() <= 0 && !player.isCreative()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        ItemStack mainHand = player.getMainHandItem();
        return FTBUltimine.isValidTool(mainHand, offHand = player.getOffhandItem()) && RestrictionHandlerRegistry.INSTANCE.canUltimine(player);
    }

    public EventResult blockBroken(Level world, BlockPos origPos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        BlockHitResult bhr;
        FTBUltiminePlayerData data;
        block13: {
            block12: {
                if (this.isBreakingBlock || !this.canUltimine((Player)player)) {
                    return EventResult.pass();
                }
                data = this.getOrCreatePlayerData((Player)player);
                if (!data.isPressed()) {
                    return EventResult.pass();
                }
                HitResult hitResult = FTBUltiminePlayerData.rayTrace(player);
                if (!(hitResult instanceof BlockHitResult)) break block12;
                bhr = (BlockHitResult)hitResult;
                if (hitResult.getType() == HitResult.Type.BLOCK) break block13;
            }
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, origPos, bhr.getDirection(), false, FTBUltimineServerConfig.getMaxBlocks(player));
        if (!data.hasCachedPositions()) {
            return EventResult.pass();
        }
        if ((double)player.totalExperience < (double)data.cachedPositions().size() * FTBUltimineServerConfig.getExperiencePerBlock(player)) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollector();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.getMainHandItem().isEmpty();
        Shape shape = data.getCurrentShape();
        float baseSpeed = state.getDestroySpeed((BlockGetter)world, origPos);
        int blocksMined = 0;
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state1 = world.getBlockState(pos);
            if (AcceleratedDecay.available && state1.is(BlockTags.LEAVES) && LogBreakTracker.INSTANCE.playerRecentlyBrokeLog((Player)player, 1500L)) {
                world.destroyBlock(pos, true, (Entity)player);
                continue;
            }
            float destroySpeed = state1.getDestroySpeed((BlockGetter)world, pos);
            if (!player.isCreative() && (destroySpeed < 0.0f || destroySpeed > baseSpeed || !player.hasCorrectToolForDrops(state1))) continue;
            if (!FTBUltimine.tryBreakBlock(player, pos, state, shape, bhr) && ((Boolean)FTBUltimineServerConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.isCreative()) {
                player.causeFoodExhaustion((float)(FTBUltimineServerConfig.getExhaustionPerBlock(player) * 0.005));
                if (FTBUltimineAPI.isTooExhausted(player)) break;
            }
            ItemStack stack = player.getMainHandItem();
            if (hadItem && stack.isEmpty() || hadItem && (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get() > 0 && stack.isDamageableItem() && stack.getDamageValue() >= stack.getMaxDamage() - (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get()) break;
            ++blocksMined;
        }
        BlockBreakingRegistry.INSTANCE.getHandlers().forEach(h -> h.postBreak((Player)player));
        if (!player.isCreative()) {
            CooldownTracker.setLastUltimineTime((Player)player, System.currentTimeMillis());
            data.addPendingXPCost(player, Math.max(0, blocksMined - 1));
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.level(), origPos);
        if (this.tempBlockDroppedXp > 0) {
            player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), (double)origPos.getX() + 0.5, (double)origPos.getY() + 0.5, (double)origPos.getZ() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SendShapePacket.adjustShapeAndBlockPos(data.getCurrentShapeIndex(), List.of()));
        return EventResult.interruptFalse();
    }

    private static boolean tryBreakBlock(ServerPlayer player, BlockPos pos, BlockState state, Shape shape, BlockHitResult bhr) {
        for (BlockBreakHandler handler : BlockBreakingRegistry.INSTANCE.getHandlers()) {
            switch (handler.breakBlock((Player)player, pos, state, shape, bhr)) {
                case SUCCESS: {
                    return true;
                }
                case FAIL: {
                    return false;
                }
            }
        }
        return player.gameMode.destroyBlock(pos);
    }

    public EventResult blockRightClick(Player player, InteractionHand hand, BlockPos clickPos, Direction face) {
        BlockHitResult blockHitResult;
        FTBUltiminePlayerData data;
        ServerPlayer serverPlayer;
        block14: {
            block13: {
                block12: {
                    block11: {
                        if (!(player instanceof ServerPlayer)) break block11;
                        serverPlayer = (ServerPlayer)player;
                        if (!PlayerHooks.isFake((Player)player) && player.getUUID() != null) break block12;
                    }
                    return EventResult.pass();
                }
                data = this.getOrCreatePlayerData(player);
                if (!data.isPressed()) {
                    return EventResult.pass();
                }
                if (player.getFoodData().getFoodLevel() <= 0 && !player.isCreative()) {
                    return EventResult.pass();
                }
                HitResult result = FTBUltiminePlayerData.rayTrace(serverPlayer);
                if (!(result instanceof BlockHitResult)) break block13;
                blockHitResult = (BlockHitResult)result;
                if (result.getType() == HitResult.Type.BLOCK) break block14;
            }
            return EventResult.pass();
        }
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, blockHitResult.getDirection(), false, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
        if (shapeContext == null || !data.hasCachedPositions()) {
            return EventResult.pass();
        }
        int didWork = RightClickDispatcher.INSTANCE.dispatchRightClick(shapeContext, hand, data);
        if (didWork > 0) {
            player.swing(hand);
            if (!player.isCreative()) {
                CooldownTracker.setLastUltimineTime(player, System.currentTimeMillis());
                data.addPendingXPCost(serverPlayer, Math.max(0, didWork - 1));
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public void playerTick(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FTBUltiminePlayerData data = this.getOrCreatePlayerData(player);
            data.checkBlocks(serverPlayer, true, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
            data.takePendingXP(serverPlayer);
        }
    }

    public EventResult entityJoinedWorld(Entity entity, Level level) {
        if (entity.isAlive()) {
            if (this.isBreakingBlock && entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (!item.getItem().isEmpty()) {
                    this.tempBlockDropsList.add(item.getItem());
                    item.setItem(ItemStack.EMPTY);
                }
                return EventResult.interruptFalse();
            }
            if (this.isBreakingBlock && entity instanceof ExperienceOrb) {
                ExperienceOrb orb = (ExperienceOrb)entity;
                this.tempBlockDroppedXp += orb.getValue();
                entity.kill();
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    static {
        LOGGER = LogManager.getLogger();
        DENY_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FTBUltimineAPI.id("excluded_tools"));
        STRICT_DENY_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FTBUltimineAPI.id("excluded_tools/strict"));
        ALLOW_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)FTBUltimineAPI.id("included_tools"));
        EXCLUDED_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimineAPI.id("excluded_blocks"));
        BLOCK_WHITELIST = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimineAPI.id("block_whitelist"));
        TILLABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimineAPI.id("farmland_tillable"));
        FLATTENABLE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)FTBUltimineAPI.id("shovel_flattenable"));
        permissionOverride = player -> true;
    }

    private static class DataReloadListener
    implements ResourceManagerReloadListener {
        private DataReloadListener() {
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            BlockMatcher.TagCache.onReload();
        }
    }
}

