/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.utils;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class AreaUtils {
    public static Stream<BlockPos> getFromRadius(BlockPos origin, Direction dir, int radius) {
        return AreaUtils.getFromRadius(origin, dir, radius, radius == 0 ? 0 : -radius + 1);
    }

    public static Stream<BlockPos> getFromRadius(BlockPos origin, Direction dir, int radius, int offset) {
        int yMin = -1;
        int yMax = 2 * radius - 1;
        if (dir == Direction.EAST || dir == Direction.WEST || dir == Direction.NORTH || dir == Direction.SOUTH) {
            origin = origin.below(offset);
        }
        return switch (dir) {
            case Direction.DOWN, Direction.UP -> BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, 0, -radius), (BlockPos)origin.offset(radius, 0, radius)).map(BlockPos::immutable);
            case Direction.NORTH, Direction.SOUTH -> BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, -radius, 0), (BlockPos)origin.offset(radius, radius, 0)).map(BlockPos::immutable);
            default -> BlockPos.betweenClosedStream((BlockPos)origin.offset(0, -radius, -radius), (BlockPos)origin.offset(0, radius, radius)).map(BlockPos::immutable);
        };
    }
}

