/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class MachinesBlockLoot
extends BlockLootSubProvider {
    public static LootTableProvider supplier(PackOutput output, CompletableFuture<HolderLookup.Provider> future) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(MachinesBlockLoot::new, LootContextParamSets.BLOCK)), future);
    }

    protected MachinesBlockLoot(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        MachinesContent.Map.ListOfBlocks.stream().filter(Predicate.not(BlockContent::hasCustomBreakRules)).map(BlockContent::block).forEach(x$0 -> this.dropSelf((Block)x$0));
        this.dropOther(MachinesContent.Block.HardenedGravel.block(), (ItemLike)Items.GRAVEL);
        this.dropOther(MachinesContent.Block.HardenedSand.block(), (ItemLike)Items.SAND);
        this.dropOther(MachinesContent.Block.HardenedRedSand.block(), (ItemLike)Items.RED_SAND);
        this.add(MachinesContent.Block.CoagulatedWater.block(), MachinesBlockLoot.noDrop());
        this.add(MachinesContent.Block.CoagulatedLava.block(), MachinesBlockLoot.noDrop());
        this.add(MachinesContent.Block.Flare.block(), MachinesBlockLoot.noDrop());
        this.add(MachinesContent.Block.PowerCore.block(), MachinesBlockLoot.noDrop());
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return MachinesContent.Map.ListOfBlocks.stream().map(BlockContent::block).collect(Collectors.toList());
    }
}

