/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.volumes;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.level.LevelEvent;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.content.volumes.ICacheableVolume;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public record CollectorVolume(BlockPos pos) implements ICacheableVolume
{
    public static final AttachmentType.Builder<VolumeLevelAttachment<CollectorVolume>> Builder = VolumeLevelAttachment.builder(CollectorVolume.class, CollectorVolume::new);

    public int getRange() {
        return (Integer)XyMachines.ServerConfig.CollectorRange.get();
    }

    public BlockPos getPos() {
        return this.pos();
    }

    public boolean isStateValid(BlockState blockState) {
        return blockState.is(MachinesContent.Block.Collector.block());
    }

    @SubscribeEvent
    public static void onLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        VolumeLevelAttachment.load((ServerLevel)serverLevel, MachinesAttachments.CollectorVolumeData);
    }
}

