/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.BufferedTankAttachment;
import tv.soaryn.xycraft.core.content.attachments.InventoryAttachment;
import tv.soaryn.xycraft.machines.content.attachments.level.ProducerTickSystemLevelAttachment;
import tv.soaryn.xycraft.machines.content.recipes.producers.atmospheric.AtmosphericVacuumRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.ProducerTickSystem;

public class AtmosphericVacuumTickSystem
extends ProducerTickSystem<AtmosphericVacuumRecipe, AtmosphericVacuumRecipe.Input> {
    public static final Codec<ProducerTickSystemLevelAttachment<AtmosphericVacuumRecipe, AtmosphericVacuumRecipe.Input>> CODEC = RecordCodecBuilder.create(builder -> ProducerTickSystemLevelAttachment.producerGroup(builder).apply((Applicative)builder, (chunkMap, frequency, enabled) -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)chunkMap, (long)frequency, (boolean)enabled, (RecipeType)MachinesRecipeTypes.AtmosphericVacuum.type().get())));
    public static final AttachmentType.Builder<ProducerTickSystemLevelAttachment<AtmosphericVacuumRecipe, AtmosphericVacuumRecipe.Input>> Builder = AttachmentType.builder(() -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(), 10L, true, (RecipeType)MachinesRecipeTypes.AtmosphericVacuum.type().get())).serialize(CODEC);

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        throw new NotImplementedException();
    }

    protected void tickBlocks(ServerLevel level, ProducerTickSystemLevelAttachment<AtmosphericVacuumRecipe, AtmosphericVacuumRecipe.Input> tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        AtmosphericVacuumRecipe recipe = this.getRecipe(level, tickData, (BlockPos)pos, state, currentStep);
        if (recipe == null) {
            return;
        }
        if (recipe.output().left().isPresent()) {
            BufferedTankAttachment data = (BufferedTankAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.BufferedTankData);
            data.Tank.fill(((FluidStack)recipe.output().left().get()).copy(), IFluidHandler.FluidAction.EXECUTE);
        } else if (recipe.output().right().isPresent()) {
            InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.SoarynBoxData);
            ItemHandlerHelper.insertItemStacked((IItemHandler)data.Inventory.asHandler(), (ItemStack)((ItemStack)recipe.output().right().get()), (boolean)false);
        }
    }

    @Override
    public AtmosphericVacuumRecipe.Input getInput(ServerLevel level, ProducerTickSystemLevelAttachment<AtmosphericVacuumRecipe, AtmosphericVacuumRecipe.Input> tickData, BlockPos pos, BlockState state, long currentStep) {
        return () -> level.getBiome(pos);
    }

    @Override
    public long getTimeRequired(AtmosphericVacuumRecipe recipe) {
        return recipe.ticks();
    }

    @NotNull
    protected Supplier<AttachmentType<ProducerTickSystemLevelAttachment<AtmosphericVacuumRecipe, AtmosphericVacuumRecipe.Input>>> getAttachmentType() {
        return MachinesAttachments.AtmosphericVacuumSystemData;
    }
}

