/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.container.item.ItemContainer;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.CollectorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class CollectorTickSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        CollectorAttachment data = (CollectorAttachment)blockEntity.getData(MachinesAttachments.CollectorData);
        IItemHandler cap = CapAccess.item((BlockEntity)blockEntity, (Direction)SidePartBlock.directionOf((BlockState)state));
        if (cap != null) {
            CollectorTickSystem.pushAllTo(data.Inventory, cap);
        }
        if (CollectorTickSystem.pushAllTo(data.Buffer, data.InventoryItemHandle)) {
            if (state.getValue(MachineStateProperties.Status) == MachineStatusColors.Idle) {
                BlockState newState = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success));
                level.setBlockAndUpdate((BlockPos)pos, newState);
                level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), newState, newState, 3, 512);
            }
        } else if (state.getValue(MachineStateProperties.Status) == MachineStatusColors.Success) {
            BlockState newState = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Idle));
            level.setBlockAndUpdate((BlockPos)pos, newState);
            level.markAndNotifyBlock((BlockPos)pos, level.getChunkAt((BlockPos)pos), newState, newState, 3, 512);
        }
    }

    private static boolean pushAllTo(ItemContainer src, IItemHandler dest) {
        boolean hasSomeRoom = false;
        for (int i = 0; i < src.size(); ++i) {
            ItemStack input = src.get(i);
            if (input.isEmpty()) {
                hasSomeRoom = true;
                continue;
            }
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)dest, (ItemStack)input, (boolean)false);
            src.set(i, result);
            if (!result.isEmpty()) continue;
            hasSomeRoom = true;
        }
        return hasSomeRoom;
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.CollectorSystemData;
    }

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.Collector.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.Collector.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Collector at block position {} was moved without calling onRemove. Take note of how you moved it and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }
}

