/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.solidifier;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.core.utils.rules.BlockRule;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.content.recipes.solidifier.SolidifierRecipe;

public class SolidifierRecipeBuilder
implements IRecipeBuilder<SolidifierRecipeBuilder, SolidifierRecipe> {
    private IRule _rule;
    private BlockState _result;

    public static SolidifierRecipeBuilder create(Block result, IRule rule) {
        SolidifierRecipeBuilder builder = new SolidifierRecipeBuilder();
        builder._rule = rule;
        builder._result = result.defaultBlockState();
        return builder;
    }

    public static SolidifierRecipeBuilder create(BlockContent result, IRule rule) {
        SolidifierRecipeBuilder builder = new SolidifierRecipeBuilder();
        builder._rule = rule;
        builder._result = result.block().defaultBlockState();
        return builder;
    }

    public static SolidifierRecipeBuilder create(BlockState result, IRule rule) {
        SolidifierRecipeBuilder builder = new SolidifierRecipeBuilder();
        builder._rule = rule;
        builder._result = result;
        return builder;
    }

    public static SolidifierRecipeBuilder create() {
        return new SolidifierRecipeBuilder();
    }

    public SolidifierRecipeBuilder to(BlockContent result) {
        return this.to(result.block());
    }

    public SolidifierRecipeBuilder to(Block result) {
        return this.to(result.defaultBlockState());
    }

    public SolidifierRecipeBuilder to(BlockState result) {
        this._result = result;
        return this;
    }

    public SolidifierRecipeBuilder from(Block block) {
        return this.from((IRule)new BlockRule(block));
    }

    public SolidifierRecipeBuilder from(IRule rule) {
        this._rule = rule;
        return this;
    }

    @NotNull
    public SolidifierRecipeBuilder ticks(long ticks) {
        return this;
    }

    @NotNull
    public SolidifierRecipe makeRecipe() {
        return new SolidifierRecipe(this._result, this._rule);
    }

    public void ensureValid(String id) {
        if (this._result == null) {
            throw new RuntimeException("Result is null in Solidifier recipe - " + id);
        }
        if (this._rule == null) {
            throw new RuntimeException("Rule is null in Solidifier Recipe - " + id);
        }
    }
}

