/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeConnectionAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public record BasicPipeConnectionLogic(BlockCapability<?, Direction> cap, BlockEntity blockEntity, long weight) implements IPipeConnection
{
    public BlockCapability<?, Direction> getHandledCap() {
        return this.cap;
    }

    public boolean canConnect(Direction side) {
        return true;
    }

    public PipeConnectionType getLogic(Direction side) {
        PipeConnectionAttachment data = (PipeConnectionAttachment)this.blockEntity.getData(MachinesAttachments.PipeConnectionData);
        return (PipeConnectionType)data.map().get((Object)side);
    }

    public void setSide(Direction side, PipeConnectionType logic) {
        PipeConnectionAttachment data = (PipeConnectionAttachment)this.blockEntity.getData(MachinesAttachments.PipeConnectionData);
        if (data.map().get((Object)side) == logic) {
            return;
        }
        data.map().put((Object)side, (Object)logic);
        this.blockEntity.setChanged();
        Level level = this.blockEntity.getLevel();
        if (level == null) {
            return;
        }
        data.sendPacket(level, this.blockEntity.getBlockPos(), true);
    }

    public boolean isClosed(Direction dir) {
        Level level = this.blockEntity.getLevel();
        if (level == null) {
            return false;
        }
        PipeConnectionType logic = this.getLogic(dir);
        return logic != PipeConnectionType.Transfer && level.hasNeighborSignal(this.blockEntity.getBlockPos());
    }
}

